/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import groovy.lang.GroovyShell;
import junit.framework.TestCase;
import org.crsh.shell.ui.LabelElement;
import org.crsh.shell.ui.TreeElement;
import org.crsh.shell.ui.UIBuilder;

public class UIBuilderTestCase
extends TestCase {
    public UIBuilderTestCase() {
    }

    public UIBuilderTestCase(String name) {
        super(name);
    }

    public void testEmptyTable() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\ndef builder = new UIBuilder();\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)0, (int)res.getElements().size());
    }

    public void testNode() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.node { };\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertNull((Object)((TreeElement)res.getElements().get(0)).getValue());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TreeElement));
        UIBuilderTestCase.assertEquals((int)0, (int)((TreeElement)res.getElements().get(0)).getSize());
    }

    public void testLabelledNode() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.node('foo') { };\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TreeElement));
        UIBuilderTestCase.assertTrue((boolean)(((TreeElement)res.getElements().get(0)).getValue() instanceof LabelElement));
        UIBuilderTestCase.assertEquals((String)"foo", (String)((LabelElement)((TreeElement)res.getElements().get(0)).getValue()).getValue());
        UIBuilderTestCase.assertEquals((int)0, (int)((TreeElement)res.getElements().get(0)).getSize());
    }

    public void testLabel() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.label('foo');\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof LabelElement));
        UIBuilderTestCase.assertEquals((String)"foo", (String)((LabelElement)res.getElements().get(0)).getValue());
    }
}

