/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.console;

import java.io.IOException;
import junit.framework.TestCase;
import org.crsh.term.console.Console;
import org.crsh.term.console.TestClientOutput;
import org.crsh.term.console.ViewWriter;

public abstract class AbstractConsoleTestCase
extends TestCase {
    protected abstract boolean getSupportsCursorMove();

    private static void assertEquals(CharSequence expected, CharSequence actual) {
        AbstractConsoleTestCase.assertEquals((String)((Object)expected).toString(), (String)((Object)actual).toString());
    }

    private Console newConsole() {
        return new Console((ViewWriter)new TestClientOutput(this.getSupportsCursorMove()));
    }

    public void testWriterCRLF() throws IOException {
        Console console;
        TestClientOutput output;
        for (String test : new String[]{"a\n", "a\r", "a\r\n"}) {
            output = new TestClientOutput(this.getSupportsCursorMove());
            console = new Console((ViewWriter)output);
            console.getWriter().write((CharSequence)test);
            output.assertChars("a\r\n");
            output.assertEmpty();
        }
        for (String test : new String[]{"a\n\n", "a\n\r", "a\r\r"}) {
            output = new TestClientOutput(this.getSupportsCursorMove());
            console = new Console((ViewWriter)output);
            console.getWriter().write((CharSequence)test);
            output.assertChars("a\r\n\r\n");
            output.assertEmpty();
        }
    }

    public void testNoCR() throws IOException {
        Console console = this.newConsole();
        console.getViewReader().write((CharSequence)"a");
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals((int)1, (int)console.getReader().getSize());
    }

    public void testReadLine() throws IOException {
        Console console;
        for (String test : new String[]{"a\n", "a\r", "a\r\n"}) {
            console = this.newConsole();
            console.getViewReader().write((CharSequence)test);
            AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals("a", console.getReader().next());
            AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals((int)0, (int)console.getReader().getSize());
        }
        for (String test : new String[]{"a\n\n", "a\n\r", "a\r\r"}) {
            console = this.newConsole();
            console.getViewReader().write((CharSequence)test);
            AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals("a", console.getReader().next());
            AbstractConsoleTestCase.assertEquals("", console.getReader().next());
            AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
            AbstractConsoleTestCase.assertEquals((int)0, (int)console.getReader().getSize());
        }
    }

    public void testErase() throws IOException {
        Console console = this.newConsole();
        console.getViewReader().write((CharSequence)"a");
        console.getViewReader().del();
        console.getViewReader().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals("b", console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    public void testMoveLeftInsert() throws IOException {
        Console console = this.newConsole();
        console.getViewReader().write((CharSequence)"a");
        console.getViewReader().moveLeft();
        console.getViewReader().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveLeftInsert(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveLeftInsert();

    public void testMoveLeftDel() throws IOException {
        Console console = this.newConsole();
        console.getViewReader().write((CharSequence)"ab");
        console.getViewReader().moveLeft();
        console.getViewReader().del();
        console.getViewReader().write((CharSequence)"\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveLeftDel(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveLeftDel();

    public void testMoveRightInsert() throws IOException {
        Console console = this.newConsole();
        console.getViewReader().write((CharSequence)"abc");
        console.getViewReader().moveLeft();
        console.getViewReader().moveLeft();
        console.getViewReader().moveRight();
        console.getViewReader().write((CharSequence)"d\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveRightInsert(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveRightInsert();

    public void testMoveRightDel() throws IOException {
        Console console = this.newConsole();
        console.getViewReader().write((CharSequence)"abc");
        console.getViewReader().moveLeft();
        console.getViewReader().moveLeft();
        console.getViewReader().moveRight();
        console.getViewReader().del();
        console.getViewReader().write((CharSequence)"\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveRightDel(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveRightDel();

    public void testMoveRightAtEndOfLine() throws IOException {
        Console console = this.newConsole();
        console.getViewReader().write((CharSequence)"a");
        console.getViewReader().moveRight();
        console.getViewReader().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveRightAtEndOfLine(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveRightAtEndOfLine();

    public void testMoveLeftAtBeginningOfLine() throws IOException {
        Console console = this.newConsole();
        console.getViewReader().write((CharSequence)"a");
        console.getViewReader().moveLeft();
        console.getViewReader().moveLeft();
        console.getViewReader().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertTrue((boolean)console.getReader().hasNext());
        AbstractConsoleTestCase.assertEquals(this.getExpectedMoveLeftAtBeginningOfLine(), console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }

    protected abstract String getExpectedMoveLeftAtBeginningOfLine();

    public void testClearBuffer() throws Exception {
        Console console = this.newConsole();
        console.getViewReader().write((CharSequence)"a");
        console.clearBuffer();
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
        console.getViewReader().write((CharSequence)"b\n");
        AbstractConsoleTestCase.assertEquals("b", console.getReader().next());
        AbstractConsoleTestCase.assertFalse((boolean)console.getReader().hasNext());
    }
}

