/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.spi;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.crsh.term.CodeType;
import org.crsh.term.spi.TermIO;

public class TestTermIO
implements TermIO {
    private final BlockingQueue<Integer> inner = new LinkedBlockingQueue<Integer>();
    private final BlockingQueue<String> outter = new LinkedBlockingQueue<String>();
    private int width = 32;

    public int read() throws IOException {
        try {
            return this.inner.take();
        }
        catch (InterruptedException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("No negative width accepted");
        }
        this.width = width;
    }

    public TestTermIO appendTab() {
        return this.append(1301);
    }

    public TestTermIO appendDel() {
        return this.append(1302);
    }

    public TestTermIO appendMoveUp() {
        return this.append(1001);
    }

    public TestTermIO appendMoveDown() {
        return this.append(1002);
    }

    public TestTermIO appendMoveRight() {
        return this.append(1003);
    }

    public TestTermIO appendMoveLeft() {
        return this.append(1004);
    }

    public TestTermIO appendBreak() {
        return this.append(3);
    }

    public TestTermIO append(char c) {
        return this.append((int)c);
    }

    public TestTermIO append(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.append(c);
        }
        return this;
    }

    private TestTermIO append(int c) {
        this.inner.add(c);
        return this;
    }

    public CodeType decode(int code) {
        switch (code) {
            case 3: {
                return CodeType.BREAK;
            }
            case 1302: {
                return CodeType.DELETE;
            }
            case 1301: {
                return CodeType.TAB;
            }
            case 1001: {
                return CodeType.UP;
            }
            case 1002: {
                return CodeType.DOWN;
            }
            case 1004: {
                return CodeType.LEFT;
            }
            case 1003: {
                return CodeType.RIGHT;
            }
        }
        return CodeType.CHAR;
    }

    public void close() {
    }

    public TestTermIO assertChar(char c) {
        return this.assertRead(String.valueOf(c));
    }

    public TestTermIO assertChars(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.assertChar(c);
        }
        return this;
    }

    public TestTermIO assertDel() {
        return this.assertRead("del");
    }

    public TestTermIO assertMoveLeft() {
        return this.assertRead("left");
    }

    public TestTermIO assertMoveRight() {
        return this.assertRead("right");
    }

    public TestTermIO assertCRLF() {
        return this.assertRead("crlf");
    }

    private TestTermIO assertRead(String expected) {
        if (expected.length() == 0) {
            Assert.fail();
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < expected.length(); ++i) {
                char c = expected.charAt(i);
                sb.append(c);
            }
            sb.append("]");
            String s = this.outter.take();
            Assert.assertEquals((String)sb.toString(), (String)s);
        }
        catch (InterruptedException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
        return this;
    }

    public void flush() throws IOException {
    }

    public void write(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.write(c);
        }
    }

    public void write(char c) throws IOException {
        System.out.print("[" + c + "]");
        this.outter.add("[" + c + "]");
    }

    public void writeDel() throws IOException {
        System.out.print("[del]");
        this.outter.add("[del]");
    }

    public void writeCRLF() throws IOException {
        System.out.print("[crlf]");
        this.outter.add("[crlf]");
    }

    public boolean moveRight(char c) throws IOException {
        System.out.print("[right]");
        this.outter.add("[right]");
        return true;
    }

    public boolean moveLeft() throws IOException {
        System.out.print("[left]");
        this.outter.add("[left]");
        return true;
    }
}

