/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.binding.TypeBinding;
import org.crsh.cmdline.matcher.ArgumentMatch;
import org.crsh.cmdline.matcher.CmdLineException;
import org.crsh.cmdline.matcher.CmdSyntaxException;
import org.crsh.cmdline.matcher.InvocationContext;
import org.crsh.cmdline.matcher.OptionMatch;
import org.crsh.cmdline.matcher.ParameterMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandMatch<C, D extends CommandDescriptor<C, B>, B extends TypeBinding> {
    private final List<OptionMatch<B>> optionMatches;
    private final List<ArgumentMatch<B>> argumentMatches;
    private final String rest;

    public CommandMatch(List<OptionMatch<B>> optionMatches, List<ArgumentMatch<B>> argumentMatches, String rest) {
        this.optionMatches = optionMatches;
        this.argumentMatches = argumentMatches;
        this.rest = rest;
    }

    public abstract D getDescriptor();

    public final Object invoke(InvocationContext context, C command) throws CmdLineException {
        Set<ParameterDescriptor<?>> unused = this.getParameters();
        HashMap parameterValues = new HashMap();
        for (ParameterMatch<?, ?> parameterMatch : this.getParameterMatches()) {
            Object parameter = parameterMatch.getParameter();
            if (!unused.remove(parameter)) {
                throw new CmdSyntaxException("Could not find parameter " + parameter);
            }
            Object v = parameterMatch.computeValue();
            if (v == null) continue;
            parameterValues.put((ParameterDescriptor<?>)parameter, v);
        }
        return this.doInvoke(context, command, parameterValues);
    }

    protected abstract Object doInvoke(InvocationContext var1, C var2, Map<ParameterDescriptor<?>, Object> var3) throws CmdLineException;

    public abstract Set<ParameterDescriptor<?>> getParameters();

    public abstract List<ParameterMatch<?, ?>> getParameterMatches();

    public abstract void printMan(Appendable var1) throws IOException;

    public abstract void printUsage(Appendable var1) throws IOException;

    public List<OptionMatch<B>> getOptionMatches() {
        return this.optionMatches;
    }

    public List<ArgumentMatch<B>> getArgumentMatches() {
        return this.argumentMatches;
    }

    public String getRest() {
        return this.rest;
    }
}

