/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.concurrent;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.concurrent.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncShell
implements Shell {
    private final Object lock = new Object();
    private Status status = Status.AVAILABLE;
    private Shell shell;
    private Process current;
    private final ExecutorService executor;

    public AsyncShell(ExecutorService executor, Shell shell) {
        this.shell = shell;
        this.current = null;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            switch (this.status) {
                case INITIAL: 
                case AVAILABLE: {
                    break;
                }
                case CANCELED: 
                case EVALUATING: {
                    throw new UnsupportedOperationException("todo :-) " + (Object)((Object)this.status));
                }
            }
            this.status = Status.CLOSED;
        }
    }

    @Override
    public String getWelcome() {
        return this.shell.getWelcome();
    }

    @Override
    public String getPrompt() {
        return this.shell.getPrompt();
    }

    @Override
    public Map<String, String> complete(String prefix) {
        return this.shell.complete(prefix);
    }

    @Override
    public ShellProcess createProcess(String request) {
        return new Process(request);
    }

    private class Process
    implements ShellProcessContext,
    Runnable,
    ShellProcess {
        private final String request;
        private ShellProcessContext caller;
        private ShellProcess callee;

        private Process(String request) {
            this.request = request;
            this.callee = null;
        }

        public int getWidth() {
            return this.caller.getWidth();
        }

        public String readLine(String msg, boolean echo) {
            return this.caller.readLine(msg, echo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end(ShellResponse response) {
            Object object = AsyncShell.this.lock;
            synchronized (object) {
                if (AsyncShell.this.status == Status.CANCELED) {
                    this.caller.end(new ShellResponse.Cancelled());
                } else {
                    this.caller.end(response);
                }
                AsyncShell.this.current = null;
                AsyncShell.this.status = Status.AVAILABLE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(ShellProcessContext processContext) {
            Object object = AsyncShell.this.lock;
            synchronized (object) {
                if (AsyncShell.this.status != Status.AVAILABLE) {
                    throw new IllegalStateException("State was " + (Object)((Object)AsyncShell.this.status));
                }
                AsyncShell.this.status = Status.EVALUATING;
                AsyncShell.this.current = this;
                this.callee = AsyncShell.this.shell.createProcess(this.request);
                this.caller = processContext;
            }
            AsyncShell.this.executor.submit(AsyncShell.this.current);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = AsyncShell.this.lock;
            synchronized (object) {
                if (AsyncShell.this.status == Status.EVALUATING) {
                    AsyncShell.this.status = Status.CANCELED;
                    this.callee.cancel();
                }
            }
        }

        public void run() {
            this.callee.execute(this);
        }
    }
}

