/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crsh.command.CommandInvoker;
import org.crsh.command.ShellCommand;
import org.crsh.shell.ErrorType;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.CRaSH;
import org.crsh.shell.impl.CRaSHProcess;
import org.crsh.shell.impl.CreateCommandException;
import org.crsh.shell.impl.InvocationContextImpl;

abstract class AST {
    AST() {
    }

    abstract Term lastTerm();

    static class Term
    extends AST {
        final String line;
        final Term next;
        final String name;
        final String rest;
        private ShellCommand command;
        private CommandInvoker invoker;

        Term(String line) {
            this(line, null);
        }

        Term(String line, Term next) {
            Pattern p = Pattern.compile("^\\s*(\\S+)");
            Matcher m = p.matcher(line);
            String name = null;
            String rest = null;
            if (m.find()) {
                name = m.group(1);
                rest = line.substring(m.end());
            }
            this.name = name;
            this.rest = rest;
            this.line = line;
            this.next = next;
        }

        private void create(CRaSH crash) throws CreateCommandException {
            CommandInvoker<?, ?> invoker = null;
            if (this.name != null) {
                this.command = crash.getCommand(this.name);
                if (this.command != null) {
                    invoker = this.command.createInvoker(this.rest);
                }
            }
            if (invoker == null) {
                throw new CreateCommandException(new ShellResponse.UnknownCommand(this.name));
            }
            this.invoker = invoker;
            if (this.next != null) {
                this.next.create(crash);
            }
        }

        String getLine() {
            return this.line;
        }

        Term lastTerm() {
            if (this.next != null) {
                return this.next.lastTerm();
            }
            return this;
        }
    }

    static class Expr
    extends AST {
        final Term term;
        final Expr next;

        Expr(Term term) {
            this.term = term;
            this.next = null;
        }

        Expr(Term term, Expr next) {
            this.term = term;
            this.next = next;
        }

        final CRaSHProcess create(CRaSH crash, String request) throws CreateCommandException {
            this.term.create(crash);
            if (this.next != null) {
                this.next.create(crash);
            }
            return new ShellProcessImpl(crash, request, this);
        }

        private void create(CRaSH crash) throws CreateCommandException {
            this.term.create(crash);
            if (this.next != null) {
                this.next.create(crash);
            }
        }

        Term lastTerm() {
            if (this.next != null) {
                return this.next.lastTerm();
            }
            if (this.term != null) {
                return this.term.lastTerm();
            }
            return null;
        }

        private static class ShellProcessImpl
        extends CRaSHProcess {
            private final Expr expr;

            private ShellProcessImpl(CRaSH crash, String request, Expr expr) {
                super(crash, request);
                this.expr = expr;
            }

            ShellResponse invoke(ShellProcessContext context) {
                return this.execute(context, this.expr, null);
            }

            private ShellResponse execute(ShellProcessContext context, Expr expr, ArrayList consumed) {
                ArrayList produced = new ArrayList();
                StringBuilder out = new StringBuilder();
                Term current = expr.term;
                while (current != null) {
                    InvocationContextImpl ctx = current.invoker.getConsumedType() == Void.class ? new InvocationContextImpl(context, null, this.crash.attributes) : new InvocationContextImpl(context, consumed, this.crash.attributes);
                    try {
                        current.invoker.invoke(ctx);
                    }
                    catch (Throwable t) {
                        return new ShellResponse.Error(ErrorType.EVALUATION, t);
                    }
                    if (ctx.getBuffer() != null) {
                        out.append(ctx.getBuffer().toString());
                    }
                    if (current.invoker.getProducedType() != Void.class) {
                        produced.addAll(ctx.getProducedItems());
                    }
                    current = current.next;
                }
                if (expr.next != null) {
                    return this.execute(context, expr.next, produced);
                }
                ShellResponse.Ok response = out.length() > 0 ? new ShellResponse.Display(produced, out.toString()) : new ShellResponse.Ok(produced);
                return response;
            }
        }
    }
}

