/*
 * Decompiled with CFR 0.152.
 */
package org.crsh;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.crsh.ProcessorListener;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.term.Term;
import org.crsh.term.TermEvent;
import org.crsh.util.FutureListener;
import org.crsh.util.LatchedFuture;
import org.crsh.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Processor
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(Processor.class);
    private final Term term;
    private final AtomicReference<Status> status;
    private final Shell shell;
    private volatile ShellProcess process;
    private final List<ProcessorListener> listeners;

    public Processor(Term term, Shell shell) {
        this.term = term;
        this.status = new AtomicReference<Status>(State.INITIAL.available);
        this.shell = shell;
        this.process = null;
        this.listeners = new ArrayList<ProcessorListener>();
    }

    public void run() {
        Result result;
        State state;
        while ((state = (result = this.execute()).getState()) != State.CLOSED) {
        }
    }

    public boolean isAvailable() {
        return this.process == null;
    }

    public State getState() {
        return this.status.get().getState();
    }

    public Result execute() {
        final Status _status = this.status.get();
        Task task = null;
        if (_status == State.INITIAL.available) {
            task = new Task(){

                @Override
                protected LatchedFuture<State> execute() {
                    try {
                        String welcome = Processor.this.shell.getWelcome();
                        Processor.this.log.debug("Writing welcome message to term");
                        Processor.this.term.write(welcome);
                        Processor.this.log.debug("Wrote welcome message to term");
                        Processor.this.writePrompt();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return new LatchedFuture<State>(State.OPEN);
                }
            };
        } else if (_status == State.OPEN.available) {
            task = new Task(){

                @Override
                protected LatchedFuture<State> execute() {
                    TermEvent event = null;
                    try {
                        Processor.this.log.debug("About to read next term event");
                        event = Processor.this.term.read();
                        Processor.this.log.debug("Read next term event " + event);
                    }
                    catch (IOException e) {
                        if (Processor.this.status.get() == State.OPEN.available) {
                            Processor.this.log.error("Could not read term data", e);
                        }
                        Processor.this.log.debug("Exception but term is considered as closed", e);
                    }
                    if (event == null) {
                        return new LatchedFuture<State>(State.OPEN);
                    }
                    if (event instanceof TermEvent.ReadLine) {
                        String line = ((Object)((TermEvent.ReadLine)event).getLine()).toString();
                        Processor.this.log.debug("Submitting command " + line);
                        ShellInvoker invoker = new ShellInvoker();
                        Processor.this.process = Processor.this.shell.createProcess(((Object)((TermEvent.ReadLine)event).getLine()).toString());
                        Processor.this.process.execute(invoker);
                        if (line.length() > 0) {
                            Processor.this.term.addToHistory(line);
                        }
                        return invoker.result;
                    }
                    if (event instanceof TermEvent.Break) {
                        if (Processor.this.process != null) {
                            Processor.this.process.cancel();
                        } else {
                            Processor.this.log.debug("Ignoring action " + event);
                            Processor.this.writePrompt();
                        }
                        return new LatchedFuture<State>(State.OPEN);
                    }
                    if (event instanceof TermEvent.Complete) {
                        String commonCompletion;
                        TermEvent.Complete complete = (TermEvent.Complete)event;
                        String prefix = ((Object)complete.getLine()).toString();
                        Processor.this.log.debug("About to get completions for " + prefix);
                        Map<String, String> completions = Processor.this.shell.complete(prefix);
                        Processor.this.log.debug("Completions for " + prefix + " are " + completions);
                        if (completions.size() == 0) {
                            commonCompletion = "";
                        } else if (completions.size() == 1) {
                            Map.Entry<String, String> entry = completions.entrySet().iterator().next();
                            commonCompletion = entry.getKey() + entry.getValue();
                        } else {
                            commonCompletion = Strings.findLongestCommonPrefix(completions.keySet());
                        }
                        if (commonCompletion.length() > 0) {
                            try {
                                Processor.this.term.bufferInsert(commonCompletion);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        } else if (completions.size() > 1) {
                            StringBuilder sb = new StringBuilder("\n");
                            Iterator<String> i = completions.keySet().iterator();
                            while (i.hasNext()) {
                                String completion = i.next();
                                sb.append(completion);
                                if (!i.hasNext()) continue;
                                sb.append(" ");
                            }
                            sb.append("\n");
                            try {
                                Processor.this.term.write(sb.toString());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            Processor.this.writePrompt();
                        }
                        return new LatchedFuture<State>(State.OPEN);
                    }
                    if (event instanceof TermEvent.Close) {
                        return new LatchedFuture<State>(State.WANT_CLOSE);
                    }
                    return new LatchedFuture<State>(State.OPEN);
                }
            };
        } else if (_status == State.WANT_CLOSE.available) {
            task = new Task(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected LatchedFuture<State> execute() {
                    ArrayList listeners;
                    Processor.this.log.debug("Closing processor");
                    List list = Processor.this.listeners;
                    synchronized (list) {
                        listeners = new ArrayList(Processor.this.listeners);
                    }
                    Processor.this.status.set(State.CLOSED.available);
                    for (ProcessorListener listener : listeners) {
                        try {
                            Processor.this.log.debug("Closing " + listener.getClass().getSimpleName());
                            listener.closed();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return new LatchedFuture<State>(State.CLOSED);
                }
            };
        }
        if (task != null) {
            final LatchedFuture<State> futureState = task.execute();
            futureState.addListener(new FutureListener<State>(){

                @Override
                public void completed(State value) {
                    Processor.this.status.set(value.available);
                }
            });
            return new Result(){

                public State getState() {
                    try {
                        return (State)((Object)futureState.get());
                    }
                    catch (InterruptedException e) {
                        return ((Status)Processor.this.status.get()).getState();
                    }
                    catch (ExecutionException e) {
                        return ((Status)Processor.this.status.get()).getState();
                    }
                }
            };
        }
        return new Result(){

            public State getState() {
                return _status.getState();
            }
        };
    }

    private void writePrompt() {
        String prompt = this.shell.getPrompt();
        try {
            String p = prompt == null ? "% " : prompt;
            this.term.write("\r\n");
            this.term.write(p);
            this.term.write(this.term.getBuffer());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ProcessorListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        List<ProcessorListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listener)) {
                throw new IllegalStateException("Already listening");
            }
            this.listeners.add(listener);
        }
    }

    private class ShellInvoker
    implements ShellProcessContext {
        private final LatchedFuture<State> result = new LatchedFuture();

        private ShellInvoker() {
        }

        public int getWidth() {
            return Processor.this.term.getWidth();
        }

        public String getProperty(String name) {
            return Processor.this.term.getProperty(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String readLine(String msg, boolean echo) {
            try {
                Processor.this.term.setEcho(echo);
                Processor.this.term.write(msg);
                TermEvent action = Processor.this.term.read();
                CharSequence line = null;
                if (action instanceof TermEvent.ReadLine) {
                    line = ((TermEvent.ReadLine)action).getLine();
                    Processor.this.log.debug("Read from console");
                } else {
                    Processor.this.log.debug("Ignoring action " + action + " returning null");
                }
                Processor.this.term.write("\r\n");
                String string = ((Object)line).toString();
                return string;
            }
            catch (Exception e) {
                Processor.this.log.error("Reading from console failed", e);
                String string = null;
                return string;
            }
            finally {
                Processor.this.term.setEcho(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end(ShellResponse response) {
            block8: {
                try {
                    if (response instanceof ShellResponse.Close) {
                        System.out.println("received close response");
                        this.result.set(State.WANT_CLOSE);
                        break block8;
                    }
                    if (response instanceof ShellResponse.Cancelled) {
                        this.result.set(State.OPEN);
                    } else {
                        String ret = response.getText();
                        Processor.this.log.debug("Command completed with result " + ret);
                        try {
                            Processor.this.term.write(ret);
                        }
                        catch (IOException e) {
                            Processor.this.log.error("Write to term failure", e);
                        }
                        Processor.this.process = null;
                    }
                    Processor.this.writePrompt();
                    this.result.set(State.OPEN);
                }
                finally {
                    Processor.this.process = null;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Task {
        private Task() {
        }

        protected abstract LatchedFuture<State> execute();
    }

    public static interface Result {
        public State getState();
    }

    public static class Status {
        private final State state;
        private final boolean available;

        private Status(State state, boolean available) {
            this.state = state;
            this.available = available;
        }

        public State getState() {
            return this.state;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public boolean isBusy() {
            return !this.available;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Status) {
                Status that = (Status)o;
                return this.state == that.state && this.available == that.available;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INITIAL,
        OPEN,
        WANT_CLOSE,
        CLOSED;

        public final Status available = new Status(this, true);
        public final Status busy = new Status(this, false);
    }
}

