/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    private final Logger log = LoggerFactory.getLogger(PluginManager.class);
    private final PluginContext context;
    private List<CRaSHPlugin<?>> plugins;
    private PluginDiscovery discovery;

    public PluginManager(PluginContext context, PluginDiscovery discovery) {
        this.context = context;
        this.plugins = null;
        this.discovery = discovery;
    }

    public synchronized Iterable<CRaSHPlugin<?>> getPlugins() {
        if (this.plugins == null) {
            List<CRaSHPlugin<?>> plugins = Utils.list(this.discovery.getPlugins());
            for (CRaSHPlugin<?> plugin : plugins) {
                plugin.context = this.context;
                plugin.status = 0;
            }
            this.plugins = plugins;
        }
        return this.plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> Iterable<T> getPlugins(Class<T> wantedType) {
        Iterable<CRaSHPlugin<?>> plugins = this.getPlugins();
        List tmp = Collections.emptyList();
        for (CRaSHPlugin<?> plugin : plugins) {
            Class<?> pluginType = plugin.getType();
            if (!wantedType.isAssignableFrom(pluginType)) continue;
            switch (plugin.status) {
                default: {
                    break;
                }
                case 0: {
                    int status = -1;
                    try {
                        plugin.status = 1;
                        plugin.init();
                        this.log.info("Initialized plugin " + plugin);
                        status = 2;
                        break;
                    }
                    catch (Exception e) {
                        this.log.error("Could not initialize plugin " + plugin, e);
                        break;
                    }
                    finally {
                        plugin.status = status;
                    }
                }
                case 1: {
                    throw new RuntimeException("Circular dependency");
                }
            }
            if (plugin.status != 2) continue;
            if (tmp.isEmpty()) {
                tmp = new ArrayList();
            }
            T t = wantedType.cast(plugin);
            tmp.add(t);
        }
        return tmp;
    }

    public void shutdown() {
        if (this.plugins != null) {
            for (CRaSHPlugin<?> plugin : this.plugins) {
                plugin.destroy();
            }
        }
    }
}

