/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.spi.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.crsh.term.CodeType;
import org.crsh.term.spi.TermIO;
import org.crsh.term.spi.net.Done;

public class TermIOClient
implements TermIO {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private int port;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private byte[] bytes = new byte[2000];
    private ByteBuffer buffer = ByteBuffer.wrap(this.bytes);

    public TermIOClient(int port) {
        this.port = port;
    }

    public void connect() throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(this.port));
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        this.socket = socket;
        this.in = in;
        this.out = out;
    }

    private void put(byte b) {
        if (this.buffer.remaining() == 0) {
            byte[] bytesCopy = new byte[this.bytes.length * 2 + 1];
            System.arraycopy(this.bytes, 0, bytesCopy, 0, this.bytes.length);
            ByteBuffer bufferCopy = ByteBuffer.wrap(bytesCopy);
            bufferCopy.position(this.buffer.position());
            this.bytes = bytesCopy;
            this.buffer = bufferCopy;
        }
        this.buffer.put(b);
    }

    private int _read(byte[] buffer, int off, int len) throws IOException, Done {
        int b = this.in.read(buffer, off, len);
        if (b == -1) {
            throw new Done();
        }
        return b;
    }

    private byte _read() throws IOException, Done {
        int b = this.in.read();
        if (b == -1) {
            throw new Done();
        }
        return (byte)b;
    }

    public int read() throws IOException {
        try {
            this.out.write(0);
            this.out.flush();
            byte b = this._read();
            CodeType codeType = CodeType.valueOf(b);
            if (codeType == null) {
                throw new UnsupportedOperationException("todo " + b);
            }
            if (codeType == CodeType.CHAR) {
                byte b1 = this._read();
                byte b2 = this._read();
                return (b1 << 8) + b2;
            }
            return codeType.ordinal() << 16;
        }
        catch (Done done) {
            throw new UnsupportedOperationException("implement me", done);
        }
    }

    public int getWidth() {
        String width = this.getProperty("width");
        return Integer.parseInt(width);
    }

    public String getProperty(String name) {
        if (name.length() == 0) {
            return null;
        }
        byte[] bytes = name.getBytes(UTF_8);
        int len = bytes.length;
        if (len > 256) {
            throw new IllegalArgumentException("Property name too long : " + name);
        }
        try {
            this.out.write(8);
            this.out.write(len - 1);
            this.out.write(bytes);
            this.out.flush();
            len = this._read();
            if (len == 0) {
                return null;
            }
            if (len == 1) {
                return "";
            }
            bytes = new byte[len - 1];
            this._read(bytes, 0, bytes.length);
            return new String(bytes, 0, bytes.length);
        }
        catch (Done done) {
            throw new UnsupportedOperationException("implement me", done);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("implement me", e);
        }
    }

    public CodeType decode(int code) {
        if ((code &= 0xFFFF0000) == 0) {
            return CodeType.CHAR;
        }
        return CodeType.valueOf(code >>= 16);
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flush() throws IOException {
        this.put((byte)7);
        this.out.write(this.bytes, 0, this.buffer.position());
        this.buffer.clear();
    }

    public void write(char c) throws IOException {
        this.put((byte)1);
        this.put((byte)((c & 0xFF00) >> 8));
        this.put((byte)(c & 0xFF));
    }

    public void write(String s) throws IOException {
        int prev = 0;
        int len = s.length();
        while (prev < len) {
            int pos = Math.min(len, prev + 257);
            int chunkLen = pos - prev;
            if (chunkLen == 1) {
                this.write(s.charAt(prev++));
                continue;
            }
            this.put((byte)2);
            this.put((byte)(chunkLen - 2));
            while (prev < pos) {
                char c = s.charAt(prev++);
                this.put((byte)((c & 0xFF00) >> 8));
                this.put((byte)(c & 0xFF));
            }
        }
    }

    public void writeDel() throws IOException {
        this.put((byte)3);
    }

    public void writeCRLF() throws IOException {
        this.put((byte)4);
    }

    public boolean moveRight(char c) throws IOException {
        this.put((byte)5);
        this.put((byte)((c & 0xFF00) >> 8));
        this.put((byte)(c & 0xFF));
        return true;
    }

    public boolean moveLeft() throws IOException {
        this.put((byte)6);
        return true;
    }
}

