/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.crsh.AbstractTestCase;
import org.crsh.BaseProcess;
import org.crsh.BaseProcessContext;
import org.crsh.BaseProcessFactory;
import org.crsh.BaseShell;
import org.crsh.CommandQueue;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.concurrent.AsyncProcess;
import org.crsh.shell.concurrent.AsyncShell;
import org.crsh.shell.concurrent.Status;

public class FailureTestCase
extends AbstractTestCase {
    public void testEvaluating() throws Exception {
        final AtomicReference failure = new AtomicReference();
        AtomicInteger cancelCount = new AtomicInteger(0);
        BaseProcessFactory factory = new BaseProcessFactory(){

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    protected ShellResponse execute(String request) {
                        throw new RuntimeException();
                    }

                    public void cancel() {
                        failure.set(AbstractTestCase.failure("Was expecting no cancel callback"));
                    }
                };
            }
        };
        BaseShell shell = new BaseShell(factory);
        CommandQueue commands = new CommandQueue();
        AsyncShell asyncShell = new AsyncShell((Executor)commands, (Shell)shell);
        BaseProcessContext ctx = BaseProcessContext.create((Shell)asyncShell, "foo").execute();
        FailureTestCase.assertEquals((Object)Status.QUEUED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        FailureTestCase.assertEquals((int)0, (int)cancelCount.get());
        FailureTestCase.assertEquals((int)1, (int)commands.getSize());
        Future<Runnable> future = commands.executeAsync();
        future.get();
        FailureTestCase.assertEquals(ShellResponse.Error.class, ctx.getResponse().getClass());
    }
}

