/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.crsh.command.ScriptException;
import org.crsh.shell.impl.Token;
import org.crsh.shell.impl.Tokenizer;

public class TokenizerTestCase
extends TestCase {
    public void testEmpty() {
        new TestTokenizer("").assertEOF();
        new TestTokenizer(" ").assertCommand(" ").assertEOF();
    }

    public void testCommand() {
        new TestTokenizer("a").assertCommand("a").assertEOF();
        new TestTokenizer("' '").assertCommand("' '").assertEOF();
        new TestTokenizer("\" \"").assertCommand("\" \"").assertEOF();
        new TestTokenizer("'\"'").assertCommand("'\"'").assertEOF();
        new TestTokenizer("\"'\"").assertCommand("\"'\"").assertEOF();
        new TestTokenizer(" ' ' ").assertCommand(" ' ' ").assertEOF();
        new TestTokenizer("'+'").assertCommand("'+'").assertEOF();
        new TestTokenizer("'|'").assertCommand("'|'").assertEOF();
        new TestTokenizer("\"+\"").assertCommand("\"+\"").assertEOF();
        new TestTokenizer("\"|\"").assertCommand("\"|\"").assertEOF();
        new TestTokenizer("\"").assertCommand("\"").assertEOF();
        new TestTokenizer("'").assertCommand("'").assertEOF();
        new TestTokenizer("a b").assertCommand("a b").assertEOF();
    }

    public void testPlus() {
        new TestTokenizer("+").assertPlus().assertEOF();
    }

    public void testPipe() {
        new TestTokenizer("|").assertPipe().assertEOF();
    }

    public void testComposite() {
        TestTokenizer tokenizer = new TestTokenizer("a | b c + d");
        tokenizer.assertCommand("a ");
        tokenizer.assertPipe();
        tokenizer.assertCommand(" b c ");
        tokenizer.assertPlus();
        tokenizer.assertCommand(" d");
        tokenizer.assertEOF();
    }

    private static class TestTokenizer
    extends Tokenizer {
        private TestTokenizer(CharSequence s) throws NullPointerException {
            super(s);
        }

        public TestTokenizer assertPipe() {
            Assert.assertEquals((Object)Token.PIPE, (Object)this.nextToken());
            return this;
        }

        public TestTokenizer assertPlus() {
            Assert.assertEquals((Object)Token.PLUS, (Object)this.nextToken());
            return this;
        }

        public void assertEOF() {
            Assert.assertEquals((Object)Token.EOF, (Object)this.nextToken());
        }

        public TestTokenizer assertCommand(String line) {
            Token.Command c = (Token.Command)this.nextToken();
            Assert.assertEquals((String)line, (String)c.line);
            return this;
        }

        public TestTokenizer assertFail() {
            try {
                this.nextToken();
                Assert.fail();
            }
            catch (ScriptException scriptException) {
                // empty catch block
            }
            return this;
        }
    }
}

