/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.processor;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.crsh.AbstractTestCase;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.term.TermEvent;
import org.crsh.term.processor.Processor;
import org.crsh.term.processor.SyncShell;
import org.crsh.term.processor.SyncTerm;

public abstract class AbstractProcessorTestCase
extends AbstractTestCase {
    protected SyncTerm term;
    protected SyncShell shell;
    protected Processor processor;
    protected Thread thread;

    protected void setUp() throws Exception {
        SyncTerm term = this.createTerm();
        SyncShell shell = this.createShell();
        Processor processor = this.createProcessor(term, shell);
        this.term = term;
        this.shell = shell;
        this.processor = processor;
        this.thread = new Thread((Runnable)processor);
        this.thread.start();
    }

    protected abstract SyncTerm createTerm();

    protected abstract SyncShell createShell();

    protected abstract Processor createProcessor(SyncTerm var1, SyncShell var2);

    public void testTermClose() throws Exception {
        final AtomicBoolean closed = new AtomicBoolean();
        this.processor.addListener(new Closeable(){

            public void close() throws IOException {
                closed.set(true);
            }
        });
        this.term.publish((TermEvent)TermEvent.close());
        AbstractProcessorTestCase.assertJoin(this.thread);
        AbstractProcessorTestCase.assertTrue((boolean)closed.get());
    }

    public void testBufferEvent() throws Exception {
        final CyclicBarrier syncA = new CyclicBarrier(2);
        final CountDownLatch syncB = new CountDownLatch(1);
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"foo"));
        this.shell.publish(new Callable<ShellResponse>(){

            @Override
            public ShellResponse call() throws Exception {
                syncA.await();
                syncB.await();
                return ShellResponse.display((String)"foo");
            }
        });
        syncA.await();
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"bar"));
        syncB.countDown();
        this.shell.publish(new Callable<ShellResponse>(){

            @Override
            public ShellResponse call() throws Exception {
                return ShellResponse.display((String)"bar");
            }
        });
        this.term.publish((TermEvent)TermEvent.close());
        AbstractProcessorTestCase.assertJoin(this.thread);
    }

    protected abstract int getBarrierSize();

    public void testCancellation() throws Exception {
        final CyclicBarrier syncA = new CyclicBarrier(2);
        final CyclicBarrier syncB = new CyclicBarrier(this.getBarrierSize());
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"foo"));
        this.shell.publish(new ShellProcess(){

            public void execute(ShellProcessContext processContext) {
                try {
                    syncA.await();
                    syncB.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void cancel() {
                try {
                    syncB.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        syncA.await();
        this.term.publish((TermEvent)TermEvent.brk());
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"bar"));
        this.shell.publish(new Callable<ShellResponse>(){

            @Override
            public ShellResponse call() throws Exception {
                return ShellResponse.display((String)"bar");
            }
        });
        this.term.publish((TermEvent)TermEvent.close());
        AbstractProcessorTestCase.assertJoin(this.thread);
    }

    public void testProcessClose() throws Exception {
        this.processor.addListener((Closeable)((Object)this.term));
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"foo"));
        this.shell.publish(new Callable<ShellResponse>(){

            @Override
            public ShellResponse call() throws Exception {
                return ShellResponse.close();
            }
        });
        AbstractProcessorTestCase.assertJoin(this.thread);
    }

    public void testReadLineCancelled() throws Exception {
        final CyclicBarrier syncA = new CyclicBarrier(2);
        final CyclicBarrier syncB = new CyclicBarrier(2);
        final CyclicBarrier syncC = new CyclicBarrier(2);
        final AtomicReference line = new AtomicReference();
        this.processor.addListener((Closeable)((Object)this.term));
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"foo"));
        this.shell.publish(new ShellProcess(){

            public void execute(ShellProcessContext processContext) {
                try {
                    syncA.await();
                    syncB.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String s = processContext.readLine("hello", true);
                if (s == null) {
                    s = "cancelled";
                }
                line.set(s);
                try {
                    syncC.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                processContext.end((ShellResponse)ShellResponse.display((String)"foo"));
            }

            public void cancel() {
            }
        });
        syncA.await();
        this.term.publish((TermEvent)TermEvent.brk());
        syncB.await();
        syncC.await();
        AbstractProcessorTestCase.assertEquals((String)"cancelled", (String)((String)line.get()));
        this.term.publish((TermEvent)TermEvent.close());
        AbstractProcessorTestCase.assertJoin(this.thread);
    }

    public void testReadLineBuffered() throws Exception {
        final CyclicBarrier syncA = new CyclicBarrier(2);
        final CyclicBarrier syncB = new CyclicBarrier(2);
        final CyclicBarrier syncC = new CyclicBarrier(2);
        final AtomicReference line = new AtomicReference();
        this.processor.addListener((Closeable)((Object)this.term));
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"foo"));
        this.shell.publish(new ShellProcess(){

            public void execute(ShellProcessContext processContext) {
                try {
                    syncA.await();
                    syncB.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String s = processContext.readLine("hello", true);
                line.set(s);
                try {
                    syncC.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                processContext.end((ShellResponse)ShellResponse.close());
            }

            public void cancel() {
            }
        });
        syncA.await();
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"bar"));
        syncB.await();
        syncC.await();
        AbstractProcessorTestCase.assertEquals((String)"bar", (String)((String)line.get()));
        AbstractProcessorTestCase.assertJoin(this.thread);
    }

    public void testReadLineIOException() throws Exception {
        final CyclicBarrier syncA = new CyclicBarrier(2);
        final CyclicBarrier syncB = new CyclicBarrier(2);
        final AtomicReference line = new AtomicReference();
        this.processor.addListener((Closeable)((Object)this.term));
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"foo"));
        this.shell.publish(new ShellProcess(){

            public void execute(ShellProcessContext processContext) {
                try {
                    syncA.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String s = processContext.readLine("hello", true);
                if (s == null) {
                    s = "cancelled";
                }
                line.set(s);
                try {
                    syncB.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                processContext.end((ShellResponse)ShellResponse.display((String)"foo"));
            }

            public void cancel() {
            }
        });
        syncA.await();
        while (!this.processor.isWaitingEvent()) {
        }
        this.term.publish(new Callable<TermEvent>(){

            @Override
            public TermEvent call() throws Exception {
                throw new IOException();
            }
        });
        syncB.await();
        AbstractProcessorTestCase.assertEquals((String)"cancelled", (String)((String)line.get()));
        this.term.publish((TermEvent)TermEvent.close());
        AbstractProcessorTestCase.assertJoin(this.thread);
    }

    public void testReadLineCancelling() throws Exception {
        final CyclicBarrier syncA = new CyclicBarrier(2);
        final CyclicBarrier syncB = new CyclicBarrier(2);
        final AtomicReference line = new AtomicReference();
        this.processor.addListener((Closeable)((Object)this.term));
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"foo"));
        this.shell.publish(new ShellProcess(){

            public void execute(ShellProcessContext processContext) {
                try {
                    syncA.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String s = processContext.readLine("hello", true);
                if (s == null) {
                    s = "cancelled";
                }
                line.set(s);
                try {
                    syncB.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                processContext.end((ShellResponse)ShellResponse.display((String)"foo"));
            }

            public void cancel() {
            }
        });
        syncA.await();
        while (!this.processor.isWaitingEvent()) {
        }
        this.term.publish((TermEvent)TermEvent.brk());
        syncB.await();
        AbstractProcessorTestCase.assertEquals((String)"cancelled", (String)((String)line.get()));
        this.term.publish((TermEvent)TermEvent.close());
        AbstractProcessorTestCase.assertJoin(this.thread);
    }
}

