/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.command.CRaSHSession;

abstract class CRaSHProcess
implements ShellProcess {
    protected final CRaSHSession crash;
    protected final String request;
    private volatile Thread thread;
    private volatile boolean cancelled;

    protected CRaSHProcess(CRaSHSession crash, String request) {
        this.crash = crash;
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ShellProcessContext processContext) {
        ClassLoader previous = this.crash.setCRaSHLoader();
        try {
            ShellResponse resp;
            this.thread = Thread.currentThread();
            if (this.crash.user != null) {
                String userName = this.crash.user != null ? this.crash.user.getName() : "unauthenticated";
                CRaSHSession.accessLog.debug("User " + userName + " executes " + this.request);
            }
            try {
                try {
                    resp = this.doInvoke(processContext);
                    if (Thread.interrupted() || this.cancelled) {
                        throw new InterruptedException("like a goto");
                    }
                }
                catch (InterruptedException e) {
                    resp = ShellResponse.cancelled();
                }
            }
            catch (Throwable t) {
                resp = ShellResponse.internalError("Unexpected error when executing process", t);
            }
            finally {
                this.thread = null;
            }
            processContext.end(resp);
            if (resp instanceof ShellResponse.Error) {
                ShellResponse.Error error = (ShellResponse.Error)resp;
                Throwable t = error.getThrowable();
                if (t != null) {
                    CRaSHSession.log.error("Error while evaluating request '" + this.request + "' " + error.getText(), t);
                } else {
                    CRaSHSession.log.error("Error while evaluating request '" + this.request + "' " + error.getText());
                }
            }
        }
        finally {
            this.crash.setPreviousLoader(previous);
        }
    }

    abstract ShellResponse doInvoke(ShellProcessContext var1) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ClassLoader previous = this.crash.setCRaSHLoader();
        try {
            Thread t = this.thread;
            if (t != null) {
                t.interrupt();
            }
            this.cancelled = true;
        }
        finally {
            this.crash.setPreviousLoader(previous);
        }
    }
}

