/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.awt.AWTError;
import java.util.EmptyStackException;
import javax.management.JMException;
import org.crsh.command.ScriptException;
import org.crsh.shell.AbstractCommandTestCase;

public class BaseCommandTestCase
extends AbstractCommandTestCase {
    private final String no_ret = "class no_ret extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\n}\n}";
    private final String compound_command = "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}";
    private final String option_command = "class option_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main(@Option(names=['o','option']) String opt) {\nreturn opt;}\n}";
    private final String checked_exception_command = "class checked_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new javax.naming.NamingException();}\n}";
    private final String script_exception_command = "class script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new org.crsh.command.ScriptException();}\n}";
    private final String groovy_script_exception_command = "class groovy_script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new groovy.util.ScriptException();}\n}";
    private final String runtime_exception_command = "class runtime_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.lang.SecurityException();}\n}";
    private final String error_command = "class error_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}";
    private final String cannot_create_command = "class cannot_create_command extends org.crsh.command.CRaSHCommand {\n{ throw new RuntimeException(); } \n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}";
    private final String produce_command = "class produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<Void, String> context) {\n['foo','bar'].each { context.produce(it) }}\n}";
    private final String compound_produce_command = "class compound_produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void compound(org.crsh.command.InvocationContext<Void, String> context) {\n['foo','bar'].each { context.produce(it) }}\n}";

    public void testUnknownCommand() throws Exception {
        this.assertUnknownCommand("bilto");
    }

    public void testThrowScript() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws org.crsh.command.ScriptException {\nthrow new org.crsh.command.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testThrowGroovyScript() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws groovy.util.ScriptException {\nthrow new groovy.util.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testThrowCheckedException() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws javax.management.JMException {\nthrow new javax.management.JMException()}\n}\n");
        this.assertEvalError("a", JMException.class);
    }

    public void testThrowRuntimeException() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws java.util.EmptyStackException {\nthrow new java.util.EmptyStackException()}\n}\n");
        this.assertEvalError("a", EmptyStackException.class);
    }

    public void testThrowError() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws java.awt.AWTError {\nthrow new java.awt.AWTError()}\n}\n");
        this.assertInternalError("a", AWTError.class);
    }

    public void testUndeclaredThrowScript() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new org.crsh.command.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testUndeclaredThrowGroovyScript() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new groovy.util.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testUndeclaredThrowCheckedException() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new javax.management.JMException()}\n}\n");
        this.assertEvalError("a", JMException.class);
    }

    public void testUndeclaredThrowRuntimeException() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new java.util.EmptyStackException()}\n}\n");
        this.assertEvalError("a", EmptyStackException.class);
    }

    public void testUndeclaredThrowError() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new java.awt.AWTError()}\n}\n");
        this.assertInternalError("a", AWTError.class);
    }

    public void testScriptThrowScript() throws Exception {
        this.lifeCycle.setCommand("a", "throw new org.crsh.command.ScriptException()");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testScriptThrowGroovyScript() throws Exception {
        this.lifeCycle.setCommand("a", "throw new groovy.util.ScriptException()");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testScriptThrowCheckedException() throws Exception {
        this.lifeCycle.setCommand("a", "throw new javax.management.JMException()");
        this.assertEvalError("a", JMException.class);
    }

    public void testScriptThrowRuntimeException() throws Exception {
        this.lifeCycle.setCommand("a", "throw new java.util.EmptyStackException()");
        this.assertEvalError("a", EmptyStackException.class);
    }

    public void testScriptThrowError() throws Exception {
        this.lifeCycle.setCommand("a", "throw new java.awt.AWTError()");
        this.assertInternalError("a", AWTError.class);
    }

    public void testAttributes() throws Exception {
        this.assertOk("null", "attribute foo");
        this.lifeCycle.setAttribute("foo", "bar");
        this.assertOk("bar", "attribute foo");
        this.lifeCycle.setAttribute("foo", null);
        this.assertOk("null", "attribute foo");
    }

    public void testInvokeNoRet() throws Exception {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nno_ret()\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("no_ret", "class no_ret extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\n}\n}");
        this.assertOk("", "foo");
    }

    public void testInvokeNoRetInScript() throws Exception {
        String foo = "no_ret()\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("no_ret", "class no_ret extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\n}\n}");
        this.assertOk("", "foo");
    }

    public void testInvoke() throws Exception {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\necho 'bar'\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.assertOk("bar", "foo");
    }

    public void testInvokeInScript() throws Exception {
        String foo = "echo 'bar'\n";
        this.lifeCycle.setCommand("foo", foo);
        this.assertOk("bar", "foo");
    }

    public void testInvokeCompound() throws Exception {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ncompound_command.compound 'bar'\n}\n}";
        this.lifeCycle.setCommand("compound_command", "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}");
        this.lifeCycle.setCommand("foo", foo);
        this.assertOk("bar", "foo");
    }

    public void testInvokeCompoundInScript() throws Exception {
        String foo = "compound_command.compound 'bar'\n";
        this.lifeCycle.setCommand("compound_command", "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}");
        this.lifeCycle.setCommand("foo", foo);
        this.assertOk("bar", "foo");
    }

    public void testShortOption() throws Exception {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\noption_command o:'bar'\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("option_command", "class option_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main(@Option(names=['o','option']) String opt) {\nreturn opt;}\n}");
        this.assertOk("bar", "foo");
    }

    public void testShortOptionInScript() throws Exception {
        String foo = "option_command o:'bar'\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("option_command", "class option_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main(@Option(names=['o','option']) String opt) {\nreturn opt;}\n}");
        this.assertOk("bar", "foo");
    }

    public void testLongOption() throws Exception {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\noption_command option:'bar'\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("option_command", "class option_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main(@Option(names=['o','option']) String opt) {\nreturn opt;}\n}");
        this.assertOk("bar", "foo");
    }

    public void testLongOptionInScript() throws Exception {
        String foo = "option_command option:'bar'\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("option_command", "class option_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main(@Option(names=['o','option']) String opt) {\nreturn opt;}\n}");
        this.assertOk("bar", "foo");
    }

    public void testCheckedException() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {checked_exception_command()} catch(javax.naming.NamingException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("checked_exception_command", "class checked_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new javax.naming.NamingException();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testCheckedExceptionInScript() {
        String foo = "try {checked_exception_command()} catch(javax.naming.NamingException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("checked_exception_command", "class checked_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new javax.naming.NamingException();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testScriptException() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("script_exception_command", "class script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new org.crsh.command.ScriptException();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testScriptExceptionInScript() {
        String foo = "try {script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("script_exception_command", "class script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new org.crsh.command.ScriptException();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testGroovyScriptException() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {groovy_script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("groovy_script_exception_command", "class groovy_script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new groovy.util.ScriptException();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testGroovyScriptExceptionInScript() {
        String foo = "try {groovy_script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("groovy_script_exception_command", "class groovy_script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new groovy.util.ScriptException();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testRuntimeException() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {runtime_exception_command()} catch(java.lang.SecurityException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("runtime_exception_command", "class runtime_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.lang.SecurityException();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testRuntimeExceptionInScript() {
        String foo = "try {runtime_exception_command()} catch(java.lang.SecurityException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("runtime_exception_command", "class runtime_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.lang.SecurityException();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testError() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {error_command()} catch(java.awt.AWTError e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("error_command", "class error_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testErrorInScript() {
        String foo = "try {error_command()} catch(java.awt.AWTError e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("error_command", "class error_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testCannotCreateCommand() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {\ncannot_create_command()} catch (org.crsh.command.NoSuchCommandException e) {\nreturn 'bar';\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("cannot_create_command", "class cannot_create_command extends org.crsh.command.CRaSHCommand {\n{ throw new RuntimeException(); } \n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testCannotCreateCommandInScript() {
        String foo = "try {\ncannot_create_command()} catch (org.crsh.command.NoSuchCommandException e) {\nreturn 'bar';\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("cannot_create_command", "class cannot_create_command extends org.crsh.command.CRaSHCommand {\n{ throw new RuntimeException(); } \n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}");
        this.assertOk("bar", "foo");
    }

    public void testProduce() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nproduce_command { out << it }\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("produce_command", "class produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<Void, String> context) {\n['foo','bar'].each { context.produce(it) }}\n}");
        this.assertOk("foobar", "foo");
    }

    public void testProduceInScript() {
        String foo = "produce_command { out << it }\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("produce_command", "class produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<Void, String> context) {\n['foo','bar'].each { context.produce(it) }}\n}");
        this.assertOk("foobar", "foo");
    }

    public void testCompoundProduce() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ncompound_produce_command.compound { out << it }\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("compound_produce_command", "class compound_produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void compound(org.crsh.command.InvocationContext<Void, String> context) {\n['foo','bar'].each { context.produce(it) }}\n}");
        this.assertOk("foobar", "foo");
    }

    public void testCompoundProduceInScript() {
        String foo = "compound_produce_command.compound { out << it }\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("compound_produce_command", "class compound_produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void compound(org.crsh.command.InvocationContext<Void, String> context) {\n['foo','bar'].each { context.produce(it) }}\n}");
        this.assertOk("foobar", "foo");
    }

    public void testClosure() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ndef closure = echo\nclosure 'bar'\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.assertOk("bar", "foo");
    }

    public void testClosureInScript() {
        String foo = "def closure = echo\nclosure 'bar'\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("compound_command", "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}");
        this.assertOk("bar", "foo");
    }

    public void testCompoundClosure() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ndef closure = compound_command.compound\nclosure()\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("compound_command", "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}");
        this.assertOk("bar", "foo");
    }

    public void testCompoundClosureInScript() {
        String foo = "def closure = compound_command.compound\nclosure()\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("compound_command", "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}");
        this.assertOk("bar", "foo");
    }
}

