/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.io.IOException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.crsh.term.BaseTerm;
import org.crsh.term.Term;
import org.crsh.term.TermEvent;
import org.crsh.term.spi.TermIO;
import org.crsh.term.spi.TestTermIO;

public class BaseTermTestCase
extends TestCase {
    private Term term;
    private TestTermIO io;

    protected void setUp() throws Exception {
        this.io = new TestTermIO();
        this.term = new BaseTerm((TermIO)this.io);
    }

    private TermEvent assertEvent() {
        try {
            return this.term.read();
        }
        catch (IOException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    private void assertLine(String expected) {
        TermEvent event = this.assertEvent();
        BaseTermTestCase.assertTrue((boolean)(event instanceof TermEvent.ReadLine));
        TermEvent.ReadLine readLine = (TermEvent.ReadLine)event;
        BaseTermTestCase.assertEquals((Object)expected, (Object)readLine.getLine());
    }

    private void assertBreak() {
        TermEvent event = this.assertEvent();
        BaseTermTestCase.assertTrue((boolean)(event instanceof TermEvent.Break));
    }

    private void assertComplete(String expected) {
        TermEvent event = this.assertEvent();
        BaseTermTestCase.assertTrue((boolean)(event instanceof TermEvent.Complete));
        TermEvent.Complete complete = (TermEvent.Complete)event;
        BaseTermTestCase.assertEquals((Object)expected, (Object)complete.getLine());
    }

    public void testLine() throws Exception {
        this.io.append("abc\r\n");
        this.assertLine("abc");
    }

    public void testDel() throws Exception {
        this.io.append("abc");
        this.io.appendDel();
        this.io.append("\r\n");
        this.assertLine("ab");
    }

    public void testBreak() throws Exception {
        this.io.append("abc");
        this.io.appendBreak();
        this.assertBreak();
    }

    public void testInsert() throws Exception {
        this.io.append("ab");
        this.io.appendMoveLeft();
        this.io.append("c\r\n");
        this.assertLine("acb");
    }

    public void testIdempotentMoveRight() throws Exception {
        this.io.append("a");
        this.io.appendMoveRight();
        this.io.append("\r\n");
        this.assertLine("a");
    }

    public void testIdempotentMoveLeft() throws Exception {
        this.io.appendMoveLeft();
        this.io.append("a");
        this.io.append("\r\n");
        this.assertLine("a");
    }

    public void testMoveUp() throws Exception {
        this.term.addToHistory((CharSequence)"foo");
        this.io.appendMoveUp();
        this.io.append("\r\n");
        this.assertLine("foo");
    }

    public void testMoveUpDuringEdition() throws Exception {
        this.term.addToHistory((CharSequence)"foo");
        this.io.append("bar");
        this.io.appendMoveLeft();
        this.io.appendMoveUp();
        this.io.append("\r\n");
        this.assertLine("foo");
    }

    public void testIdempotentMoveUp() throws Exception {
        this.term.addToHistory((CharSequence)"foo");
        this.io.appendMoveUp();
        this.io.appendMoveUp();
        this.io.append("\r\n");
        this.assertLine("foo");
    }

    public void testIdempotentMoveDown() throws Exception {
        this.term.addToHistory((CharSequence)"foo");
        this.io.appendMoveDown();
        this.io.append("\r\n");
        this.assertLine("");
    }

    public void testTab() throws Exception {
        this.io.appendTab();
        this.assertComplete("");
        this.io.append("a");
        this.io.appendTab();
        this.assertComplete("a");
        this.io.append("b");
        this.io.appendTab();
        this.assertComplete("ab");
        this.io.appendMoveLeft();
        this.io.appendTab();
        this.assertComplete("a");
    }

    public void testBufferInsert() throws Exception {
        this.io.append("a");
        this.io.moveLeft();
        this.term.getInsertBuffer().append('b');
        this.io.append("\r\n");
        this.assertLine("ba");
    }
}

