/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs.spi.ram;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.ram.RAMDriver;
import org.crsh.vfs.spi.ram.RAMURLConnection;

public class RAMURLStreamHandler
extends URLStreamHandler {
    private final RAMDriver driver;

    public RAMURLStreamHandler(RAMDriver driver) {
        this.driver = driver;
    }

    protected URLConnection openConnection(URL u) throws IOException {
        Path path = Path.get(u.getFile());
        if (path.isDir()) {
            throw new IOException("Cannot open dir");
        }
        String file = this.driver.entries.get(path);
        if (file == null) {
            throw new IOException("Cannot open non existing dir " + path);
        }
        return new RAMURLConnection(u, file);
    }
}

