/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.io;

import java.io.IOException;
import org.crsh.shell.io.ShellWriterContext;
import org.crsh.text.CharReader;
import org.crsh.text.ShellAppendable;
import org.crsh.text.Style;

public class ShellWriter
implements ShellAppendable {
    private static final int NOT_PADDED = 0;
    private static final int PADDING = 1;
    private static final int PADDED = 2;
    private final CharReader reader;
    private final String lineFeed;
    private int status;

    public ShellWriter(CharReader reader) {
        this(reader, "\r\n");
    }

    public ShellWriter(CharReader reader, String lineFeed) {
        this.reader = reader;
        this.lineFeed = lineFeed;
        this.status = 0;
    }

    public Appendable append(char c) throws IOException {
        return this.append(null, c);
    }

    public ShellWriter append(ShellWriterContext ctx, char c) throws IOException {
        return this.append(ctx, Character.toString(c));
    }

    public ShellWriter append(Style d) {
        this.reader.append((Object)d);
        return this;
    }

    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        return this.append(null, csq, start, end);
    }

    public Appendable append(CharSequence csq) throws IOException {
        return this.append(null, csq);
    }

    public ShellWriter append(ShellWriterContext ctx, CharSequence csq) throws IOException {
        return this.append(ctx, csq, 0, csq.length());
    }

    public ShellWriter append(ShellWriterContext ctx, CharSequence csq, int start, int end) throws IOException {
        int previous = start;
        int to = start + end;
        for (int i = start; i < to; ++i) {
            char c = csq.charAt(i);
            if (c == '\r') {
                if (i > previous) {
                    this.realAppend(ctx, csq, previous, i);
                }
                previous = i + 1;
                continue;
            }
            if (c != '\n') continue;
            if (i > previous) {
                this.realAppend(ctx, csq, previous, i);
            }
            this.writeLF(ctx);
            previous = i + 1;
            ++i;
        }
        if (to != previous) {
            this.realAppend(ctx, csq, previous, to);
        }
        return this;
    }

    private void realAppend(ShellWriterContext ctx, CharSequence csq, int off, int end) throws IOException {
        if (end > off) {
            switch (this.status) {
                case 0: {
                    if (ctx != null) {
                        this.status = 1;
                        ctx.pad(this);
                    }
                    this.status = 2;
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.reader.append((Object)((Object)csq.subSequence(off, end)).toString());
            switch (this.status) {
                case 1: {
                    break;
                }
                case 2: {
                    if (ctx == null) break;
                    ctx.text(csq, off, end);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private void writeLF(ShellWriterContext ctx) throws IOException {
        switch (this.status) {
            case 1: {
                throw new IllegalStateException();
            }
            case 2: {
                this.status = 0;
            }
            case 0: {
                this.reader.append((Object)this.lineFeed);
                if (ctx == null) break;
                ctx.lineFeed();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public boolean isEmpty() {
        return this.reader.isEmpty();
    }
}

