/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.standalone;

import com.sun.tools.attach.VirtualMachine;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.annotations.Argument;
import org.crsh.cmdline.annotations.Command;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.annotations.Usage;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.InvocationContext;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.processor.jline.JLineProcessor;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellFactory;
import org.crsh.shell.impl.remoting.RemoteServer;
import org.crsh.standalone.Bootstrap;
import org.crsh.util.CloseableList;
import org.crsh.util.InterruptHandler;
import org.crsh.util.Safe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRaSH {
    private static Logger log = LoggerFactory.getLogger(CRaSH.class);
    private final ClassDescriptor<CRaSH> descriptor = CommandFactory.create(CRaSH.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command
    public void main(@Option(names={"h", "help"}) @Usage(value="display standalone mode help") Boolean help, @Option(names={"j", "jar"}) @Usage(value="specify a file system path of a jar added to the class path") List<String> jars, @Option(names={"c", "cmd"}) @Usage(value="specify a file system path of a dir added to the command path") List<String> cmds, @Option(names={"conf"}) @Usage(value="specify a file system path of a dir added to the configuration path") List<String> confs, @Option(names={"p", "property"}) @Usage(value="specify a configuration property of the form a=b") List<String> properties, @Argument(name="pid") @Usage(value="the optional JVM process id to attach to") Integer pid) throws Exception {
        if (Boolean.TRUE.equals(help)) {
            this.descriptor.printUsage((Appendable)System.out);
        } else {
            Shell shell;
            CloseableList closeable = new CloseableList();
            if (pid != null) {
                URL url = CRaSH.class.getProtectionDomain().getCodeSource().getLocation();
                File f = new File(url.toURI());
                log.info("Attaching to remote process " + pid);
                final VirtualMachine vm = VirtualMachine.attach("" + pid);
                RemoteServer server = new RemoteServer(0);
                int port = server.bind();
                log.info("Callback server set on port " + port);
                StringBuilder sb = new StringBuilder();
                if (cmds != null) {
                    for (String cmd : cmds) {
                        File cmdPath = new File(cmd);
                        if (!cmdPath.exists()) continue;
                        sb.append("--cmd ");
                        Delimiter.EMPTY.escape((CharSequence)cmdPath.getCanonicalPath(), (Appendable)sb);
                        sb.append(' ');
                    }
                }
                if (confs != null) {
                    for (String conf : confs) {
                        File confPath = new File(conf);
                        if (!confPath.exists()) continue;
                        sb.append("--conf ");
                        Delimiter.EMPTY.escape((CharSequence)confPath.getCanonicalPath(), (Appendable)sb);
                        sb.append(' ');
                    }
                }
                if (jars != null) {
                    for (String jar : jars) {
                        File jarPath = new File(jar);
                        if (!jarPath.exists()) continue;
                        sb.append("--jar ");
                        Delimiter.EMPTY.escape((CharSequence)jarPath.getCanonicalPath(), (Appendable)sb);
                        sb.append(' ');
                    }
                }
                if (properties != null) {
                    for (String property : properties) {
                        sb.append("--property ");
                        Delimiter.EMPTY.escape((CharSequence)property, (Appendable)sb);
                        sb.append(' ');
                    }
                }
                sb.append(port);
                String options = sb.toString();
                log.info("Loading agent with command " + options);
                vm.loadAgent(f.getCanonicalPath(), options);
                server.accept();
                shell = server.getShell();
                closeable.add(new Closeable(){

                    public void close() throws IOException {
                        vm.detach();
                    }
                });
            } else {
                final Bootstrap bootstrap = new Bootstrap(Thread.currentThread().getContextClassLoader());
                if (cmds != null) {
                    for (String cmd : cmds) {
                        File cmdPath = new File(cmd);
                        bootstrap.addCmdPath(cmdPath);
                    }
                }
                if (confs != null) {
                    for (String conf : confs) {
                        File confPath = new File(conf);
                        bootstrap.addConfPath(confPath);
                    }
                }
                if (jars != null) {
                    for (String jar : jars) {
                        File jarPath = new File(jar);
                        bootstrap.addJarPath(jarPath);
                    }
                }
                if (properties != null) {
                    Properties config = new Properties();
                    for (String property : properties) {
                        int index = property.indexOf(61);
                        if (index == -1) {
                            config.setProperty(property, "");
                            continue;
                        }
                        config.setProperty(property.substring(0, index), property.substring(index + 1));
                    }
                    bootstrap.setConfig(config);
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                    }
                });
                bootstrap.bootstrap();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        bootstrap.shutdown();
                    }
                });
                ShellFactory factory = bootstrap.getContext().getPlugin(ShellFactory.class);
                shell = factory.create(null);
                closeable = null;
            }
            final Terminal term = TerminalFactory.create();
            term.init();
            ConsoleReader reader = new ConsoleReader(null, (InputStream)new FileInputStream(FileDescriptor.in), (OutputStream)System.out, term);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        term.restore();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            PrintWriter out = new PrintWriter(System.out);
            final JLineProcessor processor = new JLineProcessor(shell, reader, out);
            reader.addCompleter((Completer)processor);
            InterruptHandler ih = new InterruptHandler(new Runnable(){

                public void run() {
                    processor.cancel();
                }
            });
            ih.install();
            try {
                processor.run();
            }
            finally {
                if (closeable != null) {
                    Safe.close(closeable);
                }
                System.exit(0);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                line.append(' ');
            }
            Delimiter.EMPTY.escape((CharSequence)args[i], (Appendable)line);
        }
        CRaSH main = new CRaSH();
        Matcher matcher = Matcher.createMatcher((String)"main", main.descriptor);
        CommandMatch match = matcher.match(line.toString());
        match.invoke(new InvocationContext(), (Object)new CRaSH());
    }
}

