/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.io.IOException;
import java.io.Serializable;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.util.Safe;
import org.crsh.util.Utils;

public abstract class Style
implements Serializable {
    public static final Style reset = new Style(null, null, null){

        public void writeAnsiTo(Appendable appendable) throws IOException {
            appendable.append("\u001b[0m");
        }
    };
    protected final Decoration decoration;
    protected final Color foreground;
    protected final Color background;

    public static Style style(Color foreground) {
        return new Regular(null, foreground, null);
    }

    public static Style style(Color foreground, Color background) {
        return new Regular(null, foreground, background);
    }

    public static Style style(Decoration decoration, Color foreground, Color background) {
        return new Regular(decoration, foreground, background);
    }

    public static Style style(Decoration decoration) {
        return new Regular(decoration, null, null);
    }

    public static Style style(Decoration decoration, Color foreground) {
        return new Regular(decoration, foreground, null);
    }

    private Style(Decoration decoration, Color foreground, Color background) {
        this.decoration = decoration;
        this.foreground = foreground;
        this.background = background;
    }

    public Decoration getDecoration() {
        return this.decoration;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public Style merge(Style s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException();
        }
        if (s == reset) {
            return reset;
        }
        Decoration dec = Utils.notNull(s.decoration, this.decoration);
        Color fg = Utils.notNull(s.foreground, this.foreground);
        Color bg = Utils.notNull(s.background, this.background);
        return new Regular(dec, fg, bg);
    }

    public CharSequence toAnsiSequence() {
        StringBuilder sb = new StringBuilder();
        try {
            this.writeAnsiTo(sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    public abstract void writeAnsiTo(Appendable var1) throws IOException;

    public String toString() {
        return "Style[decoration=" + this.decoration + ",background=" + this.background + ",foreground=" + this.foreground + "]";
    }

    static class Regular
    extends Style {
        Regular(Decoration decoration, Color foreground, Color background) {
            super(decoration, foreground, background);
        }

        public void writeAnsiTo(Appendable appendable) throws IOException {
            if (this.decoration != null || this.foreground != null || this.background != null) {
                appendable.append("\u001b[");
                boolean appended = false;
                if (this.decoration != null) {
                    appendable.append(Integer.toString(this.decoration.code));
                    appended = true;
                }
                if (this.foreground != null) {
                    if (appended) {
                        appendable.append(";");
                    }
                    appendable.append(Integer.toString(this.foreground.code(30)));
                    appended = true;
                }
                if (this.background != null) {
                    if (appended) {
                        appendable.append(";");
                    }
                    appendable.append(Integer.toString(this.background.code(40)));
                }
                appendable.append("m");
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Regular) {
                Regular that = (Regular)obj;
                return Safe.equals(this.decoration, that.decoration) && Safe.equals(this.foreground, that.foreground) && Safe.equals(this.background, that.background);
            }
            return false;
        }
    }
}

