/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.util.Iterator;
import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Renderer {
    public static Renderer compose(Iterable<Renderer> renderers) {
        Iterator<Renderer> i = renderers.iterator();
        if (i.hasNext()) {
            Renderer renderer = i.next();
            if (i.hasNext()) {
                return new Composite(renderers);
            }
            return renderer;
        }
        return new Renderer(){

            public int getActualWidth() {
                return 0;
            }

            public int getMinWidth() {
                return 0;
            }

            public LineReader renderer(int width) {
                return new LineReader(){

                    public boolean hasLine() {
                        return false;
                    }

                    public void renderLine(RenderAppendable to) throws IllegalStateException {
                        throw new IllegalStateException();
                    }
                };
            }
        };
    }

    public abstract int getActualWidth();

    public abstract int getMinWidth();

    public abstract LineReader renderer(int var1);

    public final void render(RenderAppendable out) {
        LineReader renderer = this.renderer(out.getWidth());
        if (renderer != null) {
            while (renderer.hasLine()) {
                renderer.renderLine(out);
                out.append('\n');
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Composite
    extends Renderer {
        private final Iterable<? extends Renderer> renderers;
        private final int actualWidth;
        private final int minWidth;

        private Composite(Iterable<? extends Renderer> renderers) {
            int actualWidth = 0;
            int minWidth = 0;
            for (Renderer renderer : renderers) {
                actualWidth = Math.max(actualWidth, renderer.getActualWidth());
                minWidth = Math.max(minWidth, renderer.getMinWidth());
            }
            this.actualWidth = actualWidth;
            this.minWidth = minWidth;
            this.renderers = renderers;
        }

        @Override
        public int getActualWidth() {
            return this.actualWidth;
        }

        @Override
        public int getMinWidth() {
            return this.minWidth;
        }

        @Override
        public LineReader renderer(final int width) {
            return new LineReader(){
                Iterator<? extends Renderer> i;
                LineReader current;
                {
                    this.i = Composite.this.renderers.iterator();
                    this.current = null;
                }

                public boolean hasLine() {
                    while (true) {
                        if (this.current != null) {
                            if (this.current.hasLine()) break;
                            this.current = null;
                            continue;
                        }
                        if (!this.i.hasNext()) break;
                        this.current = this.i.next().renderer(width);
                    }
                    return this.current != null;
                }

                public void renderLine(RenderAppendable to) throws IllegalStateException {
                    if (!this.hasLine()) {
                        throw new IllegalStateException();
                    }
                    this.current.renderLine(to);
                }
            };
        }
    }
}

