/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.crsh.Pipe;
import org.crsh.command.BaseCommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.InvocationContext;
import org.crsh.command.PipeCommand;
import org.crsh.command.ShellCommand;
import org.crsh.text.Chunk;
import org.crsh.text.ChunkBuffer;
import org.crsh.text.RenderPrintWriter;
import org.crsh.text.RenderingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestInvocationContext<C, P>
extends BaseCommandContext
implements InvocationContext<P> {
    protected List<P> producedItems;
    protected ChunkBuffer reader = null;
    protected RenderPrintWriter writer = null;
    private final Pipe<P> producer = new PipeCommand<P>(){

        public void provide(P element) throws IOException {
            if (TestInvocationContext.this.producedItems.isEmpty()) {
                TestInvocationContext.this.producedItems = new LinkedList();
            }
            TestInvocationContext.this.producedItems.add(element);
        }
    };

    public TestInvocationContext() {
        super(new HashMap(), new HashMap());
        this.producedItems = Collections.emptyList();
    }

    public List<P> getProducedItems() {
        return this.producedItems;
    }

    public ChunkBuffer getReader() {
        return this.reader;
    }

    public int getWidth() {
        return 32;
    }

    public int getHeight() {
        return 40;
    }

    public String getProperty(String propertyName) {
        return null;
    }

    public String readLine(String msg, boolean echo) {
        throw new UnsupportedOperationException();
    }

    public String execute(ShellCommand command, String ... args) throws Exception {
        if (this.reader != null) {
            this.reader.clear();
        }
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(arg);
        }
        CommandInvoker invoker = command.resolveInvoker(sb.toString());
        PipeCommand pc = invoker.invoke((InvocationContext)this);
        pc.open();
        pc.close();
        return this.reader != null ? this.reader.toString() : null;
    }

    public void provide(P element) throws IOException {
        this.producer.provide(element);
    }

    public void flush() throws IOException {
        this.producer.flush();
    }

    public RenderPrintWriter getWriter() {
        if (this.writer == null) {
            this.reader = new ChunkBuffer();
            this.writer = new RenderPrintWriter(new RenderingContext(){

                public int getWidth() {
                    return TestInvocationContext.this.getWidth();
                }

                public void provide(Chunk element) throws IOException {
                    TestInvocationContext.this.reader.provide(element);
                }

                public void flush() throws IOException {
                    TestInvocationContext.this.reader.flush();
                }
            });
        }
        return this.writer;
    }
}

