/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.crsh.AbstractTestCase;
import org.crsh.BaseProcess;
import org.crsh.BaseProcessContext;
import org.crsh.BaseProcessFactory;
import org.crsh.BaseShell;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.spi.ValueCompletion;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.async.AsyncShell;
import org.crsh.shell.impl.remoting.ClientAutomaton;
import org.crsh.shell.impl.remoting.ClientMessage;
import org.crsh.shell.impl.remoting.ServerAutomaton;
import org.crsh.shell.impl.remoting.ServerMessage;
import org.crsh.text.Text;
import org.crsh.util.PipedChannel;

public class RemoteShellTestCase
extends AbstractTestCase {
    private ObjectInputStream serverOIS;
    private ObjectOutputStream clientOOS;
    private ObjectInputStream clientOIS;
    private ObjectOutputStream serverOOS;

    protected void setUp() throws Exception {
        ObjectInputStream clientOIS;
        PipedChannel a = new PipedChannel();
        PipedChannel b = new PipedChannel();
        ObjectOutputStream clientOOS = new ObjectOutputStream((OutputStream)a.getOut());
        clientOOS.flush();
        ObjectOutputStream serverOOS = new ObjectOutputStream((OutputStream)b.getOut());
        serverOOS.flush();
        ObjectInputStream serverOIS = new ObjectInputStream((InputStream)a.getIn());
        this.clientOIS = clientOIS = new ObjectInputStream((InputStream)b.getIn());
        this.clientOOS = clientOOS;
        this.serverOIS = serverOIS;
        this.serverOOS = serverOOS;
    }

    public void testPrompt() throws Exception {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(){

            public String getPrompt() {
                return "foo";
            }
        });
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        RemoteShellTestCase.assertEquals((String)"foo", (String)server.getPrompt());
        t.interrupt();
        RemoteShellTestCase.assertJoin(t);
    }

    public void testWelcome() throws Exception {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(){

            public String getWelcome() {
                return "bar";
            }
        });
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        RemoteShellTestCase.assertEquals((String)"bar", (String)server.getWelcome());
        t.interrupt();
        RemoteShellTestCase.assertJoin(t);
    }

    public void testExecute() throws Exception {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(new BaseProcessFactory(){

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    public void process(String request, ShellProcessContext processContext) throws IOException {
                        processContext.provide((Object)new Text((CharSequence)"juu"));
                        processContext.end((ShellResponse)ShellResponse.ok());
                    }
                };
            }
        }));
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        ShellProcess process = server.createProcess("hello");
        BaseProcessContext context = BaseProcessContext.create(process);
        context.execute();
        RemoteShellTestCase.assertInstance(ShellResponse.Ok.class, context.getResponse());
        RemoteShellTestCase.assertEquals((String)"juu", (String)context.getOutput());
        t.interrupt();
        RemoteShellTestCase.assertJoin(t);
    }

    public void testClose() throws Exception {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(new BaseProcessFactory(){

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    protected ShellResponse execute(String request) {
                        return ShellResponse.close();
                    }
                };
            }
        }));
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        ShellProcess process = server.createProcess("hello");
        BaseProcessContext context = BaseProcessContext.create(process);
        context.execute();
        ShellResponse response = context.getResponse();
        RemoteShellTestCase.assertInstance(ShellResponse.Close.class, response);
        RemoteShellTestCase.assertJoin(t);
    }

    public void testRawClose() throws Exception {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(new BaseProcessFactory(){

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    protected ShellResponse execute(String request) {
                        return ShellResponse.close();
                    }
                };
            }
        }));
        t.start();
        this.serverOOS.writeObject(ClientMessage.EXECUTE);
        this.serverOOS.writeObject(32);
        this.serverOOS.writeObject(40);
        this.serverOOS.writeObject("");
        this.serverOOS.flush();
        ServerMessage proto = (ServerMessage)this.serverOIS.readObject();
        RemoteShellTestCase.assertEquals((Object)ServerMessage.END, (Object)proto);
        ShellResponse response = (ShellResponse)this.serverOIS.readObject();
        RemoteShellTestCase.assertInstance(ShellResponse.Close.class, response);
        try {
            this.serverOIS.readObject();
            RemoteShellTestCase.fail();
        }
        catch (IOException e) {
            // empty catch block
        }
        RemoteShellTestCase.assertJoin(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCancel() throws Exception {
        final AtomicBoolean waiting = new AtomicBoolean();
        final Object lock = new Object();
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, (Shell)new AsyncShell((Executor)Executors.newCachedThreadPool(), (Shell)new BaseShell(new BaseProcessFactory(){

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void process(String request, ShellProcessContext processContext) throws IOException {
                        Object object = lock;
                        synchronized (object) {
                            if (waiting.get()) {
                                lock.notifyAll();
                            } else {
                                waiting.set(true);
                            }
                            try {
                                lock.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        processContext.provide((Object)new Text((CharSequence)"juu"));
                        processContext.end((ShellResponse)ShellResponse.ok());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void cancel() {
                        Object object = lock;
                        synchronized (object) {
                            lock.notifyAll();
                        }
                    }
                };
            }
        })));
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        ShellProcess process = server.createProcess("hello");
        final BaseProcessContext context = BaseProcessContext.create(process);
        Thread u = new Thread(){

            public void run() {
                context.execute();
                ShellResponse response = context.getResponse();
                AbstractTestCase.assertInstance(ShellResponse.Cancelled.class, response);
            }
        };
        u.start();
        Object object = lock;
        synchronized (object) {
            if (!waiting.get()) {
                waiting.set(true);
                lock.wait();
            }
        }
        process.cancel();
        t.interrupt();
        RemoteShellTestCase.assertJoin(t);
    }

    public void testComplete() {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(){

            public CommandCompletion complete(String prefix) {
                return new CommandCompletion(Delimiter.DOUBLE_QUOTE, new ValueCompletion(prefix, Collections.singletonMap("ix", true)));
            }
        });
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        CommandCompletion completion = server.complete("pref");
        RemoteShellTestCase.assertEquals((Object)Delimiter.DOUBLE_QUOTE, (Object)completion.getDelimiter());
        ValueCompletion value = completion.getValue();
        RemoteShellTestCase.assertEquals((String)"pref", (String)value.getPrefix());
        RemoteShellTestCase.assertEquals((int)1, (int)value.getSize());
        RemoteShellTestCase.assertEquals(Collections.singleton("ix"), (Object)value.getSuffixes());
        RemoteShellTestCase.assertEquals((Object)true, (Object)value.get("ix"));
        t.interrupt();
        RemoteShellTestCase.assertJoin(t);
    }

    static class ClientProcessor
    extends Thread {
        final ObjectInputStream in;
        final ObjectOutputStream out;
        final Shell shell;

        ClientProcessor(ObjectInputStream in, ObjectOutputStream out, Shell shell) {
            this.in = in;
            this.out = out;
            this.shell = shell;
        }

        public void run() {
            ClientAutomaton client = new ClientAutomaton(this.out, this.in, this.shell);
            client.run();
        }
    }
}

