/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.io.IOException;
import java.util.List;
import org.crsh.AbstractTestCase;
import org.crsh.text.Chunk;
import org.crsh.text.ChunkBuffer;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.Style;
import org.crsh.text.Text;
import org.crsh.util.Utils;

public class ChunkBufferTestCase
extends AbstractTestCase {
    private static final Style RED = Style.style(null, null, (Color)Color.red);
    private static final Style BLUE = Style.style(null, null, (Color)Color.blue);
    private static final Style UNDERLINE = Style.style((Decoration)Decoration.underline, null, null);
    private static final Style RED_UNDERLINE = Style.style((Decoration)Decoration.underline, null, (Color)Color.red);

    public void testSimple() {
        this.assertReader(new ChunkBuffer().append((CharSequence)"a"), new Chunk[]{new Text((CharSequence)"a")});
        this.assertReader(new ChunkBuffer().append(new Object[]{RED, "a"}), new Chunk[]{RED, new Text((CharSequence)"a")});
    }

    public void testMergeCharSequence() {
        this.assertReader(new ChunkBuffer().append((CharSequence)"a").append((CharSequence)"b"), new Chunk[]{new Text((CharSequence)"ab")});
    }

    public void testMergeColor() {
        this.assertReader(new ChunkBuffer().append(new Object[]{RED, "a", RED, "b"}), new Chunk[]{RED, new Text((CharSequence)"ab")});
    }

    public void testOverwriteColor() {
        this.assertReader(new ChunkBuffer().append(new Object[]{BLUE, RED, "a"}), new Chunk[]{RED, new Text((CharSequence)"a")});
    }

    public void testOverwriteMergeColor() {
        this.assertReader(new ChunkBuffer().append(new Object[]{RED, "a", BLUE, RED, "b"}), new Chunk[]{RED, new Text((CharSequence)"ab")});
    }

    public void testLastColor() {
        this.assertReader(new ChunkBuffer().append(new Object[]{RED, "a", BLUE}), new Chunk[]{RED, new Text((CharSequence)"a")});
    }

    public void testBlendStyle() {
        this.assertReader(new ChunkBuffer().append(new Object[]{RED, UNDERLINE, "a"}), new Chunk[]{RED_UNDERLINE, new Text((CharSequence)"a")});
    }

    public void testConcatenation() {
        this.assertReader(new ChunkBuffer().append(RED).append(new ChunkBuffer().append((CharSequence)"a")), new Chunk[]{RED, new Text((CharSequence)"a")});
        this.assertReader(new ChunkBuffer().append(new ChunkBuffer().append(RED)).append((CharSequence)"a"), new Chunk[]{RED, new Text((CharSequence)"a")});
    }

    public void testBlend() throws IOException {
        this.assertReader(new ChunkBuffer().append(new Object[]{Color.red.fg(), "foo", Color.red.fg(), "bar"}), new Chunk[]{Color.red.fg(), new Text((CharSequence)"foobar")});
    }

    private void assertReader(ChunkBuffer reader, Chunk ... expected) {
        List res = Utils.list((Iterable)reader);
        ChunkBufferTestCase.assertEquals((int)expected.length, (int)res.size());
        for (int i = 0; i < expected.length; ++i) {
            ChunkBufferTestCase.assertEquals((Object)expected[i], res.get(i));
        }
    }
}

