/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.AbstractRendererTestCase;
import org.crsh.text.ui.Border;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.TableElement;
import org.crsh.text.ui.TreeElement;

public class RendererTestCase
extends AbstractRendererTestCase {
    public void testInNode() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")}));
        TreeElement node = new TreeElement();
        node.addChild((Element)Element.label((String)"foo"));
        node.addChild((Element)tableElement);
        node.addChild((Element)Element.label((String)"bar"));
        this.assertRender((Element)node, 32, "+-foo                           ", "+-ab                            ", "| cd                            ", "+-bar                           ");
    }

    public void testCascading() throws Exception {
        Element custom = new Element(){
            LabelElement foo = new LabelElement("foo");
            LabelElement bar = new LabelElement("bar").style(Style.style((Decoration)Decoration.bold_off));
            LabelElement juu = new LabelElement("juu");

            public Renderer renderer() {
                return new Renderer(){

                    public int getActualWidth() {
                        return 9;
                    }

                    public int getMinWidth() {
                        return 1;
                    }

                    public LineReader renderer(int width) {
                        return new LineReader(){
                            boolean done = false;

                            public boolean hasLine() {
                                return !this.done;
                            }

                            public void renderLine(RenderAppendable to) throws IllegalStateException {
                                if (this.done) {
                                    throw new IllegalStateException();
                                }
                                foo.renderer().renderer(3).renderLine(to);
                                bar.renderer().renderer(3).renderLine(to);
                                juu.renderer().renderer(3).renderLine(to);
                                this.done = true;
                            }
                        };
                    }
                };
            }
        };
        TableElement table = new TableElement().style(Style.style((Decoration)Decoration.bold)).add(Element.row().style(Color.red.fg()).add(new Element[]{custom}));
        this.assertRender((Element)table, 32, "\u001b[1;31mfoo\u001b[22mbar\u001b[1mjuu\u001b[39m                       ");
    }

    public void testStyleOff() {
        TableElement table = new TableElement().border(Border.dashed).style(Style.style((Decoration)Decoration.bold)).add(Element.row().style(Style.style((Decoration)Decoration.underline)).add(new Element[]{Element.label((String)"foo"), Element.label((String)"bar")}));
        this.assertRender((Element)table, 32, " -------                        ", "\u001b[0m|\u001b[1;4mfoo\u001b[0m|\u001b[1;4mbar\u001b[0m|                       ", " -------                        ");
    }
}

