/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import org.crsh.text.ui.AbstractRendererTestCase;
import org.crsh.text.ui.Border;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.RowElement;

public class RowRendererTestCase
extends AbstractRendererTestCase {
    public void testRender() throws Exception {
        RowElement row = new RowElement().add(new Element[]{new LabelElement("foo"), new LabelElement("bar")});
        this.assertRender((Element)row, 8, "foobar  ");
        this.assertRender((Element)row, 7, "foobar ");
        this.assertRender((Element)row, 6, "foobar");
        this.assertRender((Element)row, 5, "fooba", "   r ");
        this.assertRender((Element)row, 4, "foob", "   a", "   r");
        this.assertRender((Element)row, 3, "foo");
        this.assertRender((Element)row, 2, "fo", "o ");
        this.assertRender((Element)row, 1, "f", "o", "o");
        this.assertRender((Element)row, 0, new String[0]);
    }

    private void assertRenderWithBorder(RowElement row, int width, String ... expected) {
        this.assertRender(row.renderer().renderer(width, Border.dashed), width, expected);
    }

    public void testRenderWithBorder() throws Exception {
        RowElement row = new RowElement().add(new Element[]{new LabelElement("foo"), new LabelElement("bar")});
        this.assertRenderWithBorder(row, 11, "|foo|bar|  ");
        this.assertRenderWithBorder(row, 10, "|foo|bar| ");
        this.assertRenderWithBorder(row, 9, "|foo|bar|");
        this.assertRenderWithBorder(row, 8, "|foo|ba|", "|   |r |");
        this.assertRenderWithBorder(row, 7, "|foo|b|", "|   |a|", "|   |r|");
        this.assertRenderWithBorder(row, 6, "|foo| ");
        this.assertRenderWithBorder(row, 5, "|foo|");
        this.assertRenderWithBorder(row, 4, "|fo|", "|o |");
        this.assertRenderWithBorder(row, 3, "|f|", "|o|", "|o|");
        this.assertRenderWithBorder(row, 2, new String[0]);
        this.assertRenderWithBorder(row, 1, new String[0]);
        this.assertRenderWithBorder(row, 0, new String[0]);
    }

    public void testCosmetic() throws Exception {
        RowElement row = new RowElement().add(new Element[]{new LabelElement("foo", 5), new LabelElement("This text is larger to be displayed in a cell of 32", 5)});
        this.assertRender((Element)row, 32, "fooThis text is larger to be dis", "   played in a cell of 32       ");
    }
}

