/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.remoting;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.remoting.ClientMessage;
import org.crsh.shell.impl.remoting.ServerMessage;
import org.crsh.shell.impl.remoting.ServerProcess;
import org.crsh.text.Chunk;
import org.crsh.util.CloseableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAutomaton
implements Shell {
    final Logger log = LoggerFactory.getLogger(ServerAutomaton.class);
    final ObjectInputStream in;
    final ObjectOutputStream out;
    ServerProcess process;
    final CloseableList listeners;

    public ServerAutomaton(ObjectOutputStream out, ObjectInputStream in) {
        CloseableList listeners = new CloseableList();
        listeners.add(in);
        listeners.add(out);
        this.in = in;
        this.out = out;
        this.listeners = listeners;
    }

    public ServerAutomaton(InputStream in, OutputStream out) throws IOException {
        this(new ObjectOutputStream(out), new ObjectInputStream(in));
    }

    public ServerAutomaton addCloseListener(Closeable closeable) {
        this.listeners.add(closeable);
        return this;
    }

    public String getWelcome() {
        try {
            this.out.writeObject((Object)ClientMessage.GET_WELCOME);
            this.out.flush();
            return (String)this.in.readObject();
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public String getPrompt() {
        try {
            this.out.writeObject((Object)ClientMessage.GET_PROMPT);
            this.out.flush();
            return (String)this.in.readObject();
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public ShellProcess createProcess(String request) throws IllegalStateException {
        return new ServerProcess(this, request);
    }

    public CommandCompletion complete(String prefix) {
        try {
            this.out.writeObject((Object)ClientMessage.GET_COMPLETION);
            this.out.writeObject(prefix);
            this.out.flush();
            return (CommandCompletion)this.in.readObject();
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void close() {
        this.listeners.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(ServerProcess process, ShellProcessContext processContext) throws IllegalStateException {
        if (this.process != null) {
            throw new IllegalStateException();
        }
        this.process = process;
        ShellResponse response = null;
        try {
            this.out.writeObject((Object)ClientMessage.EXECUTE);
            this.out.writeObject(processContext.getWidth());
            this.out.writeObject(processContext.getHeight());
            this.out.writeObject(process.line);
            this.out.flush();
            block13: while (response == null) {
                ServerMessage msg = (ServerMessage)((Object)this.in.readObject());
                switch (msg) {
                    case GET_SIZE: {
                        this.out.writeObject((Object)ClientMessage.SET_SIZE);
                        int width = processContext.getWidth();
                        int height = processContext.getHeight();
                        this.out.writeObject(width);
                        this.out.writeObject(height);
                        this.out.flush();
                        continue block13;
                    }
                    case READLINE: {
                        throw new UnsupportedOperationException("Not handled");
                    }
                    case USE_ALTERNATE_BUFFER: {
                        processContext.takeAlternateBuffer();
                        continue block13;
                    }
                    case USE_MAIN_BUFFER: {
                        processContext.releaseAlternateBuffer();
                        continue block13;
                    }
                    case END: {
                        response = (ShellResponse)this.in.readObject();
                        continue block13;
                    }
                    case CHUNK: {
                        Chunk chunk = (Chunk)this.in.readObject();
                        processContext.provide(chunk);
                        continue block13;
                    }
                    case FLUSH: {
                        processContext.flush();
                        continue block13;
                    }
                }
                response = ShellResponse.internalError("Unexpected");
            }
            this.process = null;
            if (response != null) {
                processContext.end(response);
            } else {
                processContext.end(ShellResponse.internalError(""));
            }
        }
        catch (Exception e) {
            try {
                this.log.error("Remoting issue", (Throwable)e);
                response = ShellResponse.internalError("Remoting issue", e);
                this.process = null;
                if (response != null) {
                    processContext.end(response);
                } else {
                    processContext.end(ShellResponse.internalError(""));
                }
            }
            catch (Throwable throwable) {
                this.process = null;
                if (response != null) {
                    processContext.end(response);
                } else {
                    processContext.end(ShellResponse.internalError(""));
                }
                throw throwable;
            }
        }
    }

    void cancel(ServerProcess process) throws IllegalStateException {
        if (process == this.process) {
            this.process = null;
            try {
                this.out.writeObject((Object)ClientMessage.CANCEL);
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

