/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.crsh.command.ScriptException;
import org.crsh.shell.AbstractCommandTestCase;
import org.crsh.shell.ErrorType;
import org.crsh.util.Utils;

public class FilterCommandTestCase
extends AbstractCommandTestCase {
    public static List<Map> output = new ArrayList<Map>();
    private final String consume_command = "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<java.util.Map, Object> main() {\nreturn new org.crsh.command.PipeCommand<java.util.Map, Object>() {\npublic void provide(java.util.Map element) {\norg.crsh.shell.FilterCommandTestCase.output.add(element)\n}\n}\n}\n}";
    private final String produce_command = "class produce_command {\n@Command\npublic void main(org.crsh.command.InvocationContext<java.util.Map> context) {\ncontext.provide([A:'A',B:'C']);\ncontext.provide([A:'B',B:'B']);\ncontext.provide([A:'C',B:'A']);\n}\n}";

    public void testSimple() throws Exception {
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<java.util.Map, Object> main() {\nreturn new org.crsh.command.PipeCommand<java.util.Map, Object>() {\npublic void provide(java.util.Map element) {\norg.crsh.shell.FilterCommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.lifeCycle.bind("produce_command", "class produce_command {\n@Command\npublic void main(org.crsh.command.InvocationContext<java.util.Map> context) {\ncontext.provide([A:'A',B:'C']);\ncontext.provide([A:'B',B:'B']);\ncontext.provide([A:'C',B:'A']);\n}\n}");
        this.assertOk("produce_command | filter -p A:C | consume_command");
        FilterCommandTestCase.assertEquals((Object)Utils.list((Object[])new HashMap[]{(HashMap)Utils.map((Map)Utils.map((Object)"A", (Object)"C"), (Object)"B", (Object)"A")}), output);
    }

    public void testMany() throws Exception {
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<java.util.Map, Object> main() {\nreturn new org.crsh.command.PipeCommand<java.util.Map, Object>() {\npublic void provide(java.util.Map element) {\norg.crsh.shell.FilterCommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.lifeCycle.bind("produce_command", "class produce_command {\n@Command\npublic void main(org.crsh.command.InvocationContext<java.util.Map> context) {\ncontext.provide([A:'A',B:'C']);\ncontext.provide([A:'B',B:'B']);\ncontext.provide([A:'C',B:'A']);\n}\n}");
        this.assertOk("produce_command | filter -p A:C -p A:B | consume_command");
        FilterCommandTestCase.assertEquals((Object)Utils.list((Object[])new HashMap[]{(HashMap)Utils.map((Map)Utils.map((Object)"A", (Object)"B"), (Object)"B", (Object)"B"), (HashMap)Utils.map((Map)Utils.map((Object)"A", (Object)"C"), (Object)"B", (Object)"A")}), output);
    }

    public void testInvalid() throws Exception {
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<java.util.Map, Object> main() {\nreturn new org.crsh.command.PipeCommand<java.util.Map, Object>() {\npublic void provide(java.util.Map element) {\norg.crsh.shell.FilterCommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.lifeCycle.bind("produce_command", "class produce_command {\n@Command\npublic void main(org.crsh.command.InvocationContext<java.util.Map> context) {\ncontext.provide([A:'A',B:'C']);\ncontext.provide([A:'B',B:'B']);\ncontext.provide([A:'C',B:'A']);\n}\n}");
        this.assertError("produce_command | filter -p invalid | consume_command", ErrorType.EVALUATION, ScriptException.class);
    }

    public void testIntersect() throws Exception {
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<java.util.Map, Object> main() {\nreturn new org.crsh.command.PipeCommand<java.util.Map, Object>() {\npublic void provide(java.util.Map element) {\norg.crsh.shell.FilterCommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.lifeCycle.bind("produce_command", "class produce_command {\n@Command\npublic void main(org.crsh.command.InvocationContext<java.util.Map> context) {\ncontext.provide([A:'A',B:'C']);\ncontext.provide([A:'B',B:'B']);\ncontext.provide([A:'C',B:'A']);\n}\n}");
        this.assertOk("produce_command | filter -p A:C -p B:A | consume_command");
        FilterCommandTestCase.assertEquals((Object)Utils.list((Object[])new HashMap[]{(HashMap)Utils.map((Map)Utils.map((Object)"A", (Object)"C"), (Object)"B", (Object)"A")}), output);
    }
}

