/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.remoting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.crsh.AbstractTestCase;
import org.crsh.BaseProcess;
import org.crsh.BaseProcessContext;
import org.crsh.BaseProcessFactory;
import org.crsh.BaseShell;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completion;
import org.crsh.shell.ErrorType;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.remoting.ClientAutomaton;
import org.crsh.shell.impl.remoting.ClientMessage;
import org.crsh.shell.impl.remoting.ServerAutomaton;
import org.crsh.shell.impl.remoting.ServerMessage;
import org.crsh.text.Text;

public class RemoteShellTestCase
extends AbstractTestCase {
    private ObjectInputStream serverOIS;
    private ObjectOutputStream clientOOS;
    private ObjectInputStream clientOIS;
    private ObjectOutputStream serverOOS;

    protected void setUp() throws Exception {
        ObjectInputStream clientOIS;
        PipedInputStream a = new PipedInputStream();
        PipedOutputStream b = new PipedOutputStream(a);
        PipedInputStream c = new PipedInputStream();
        PipedOutputStream d = new PipedOutputStream(c);
        ObjectOutputStream clientOOS = new ObjectOutputStream(b);
        clientOOS.flush();
        ObjectOutputStream serverOOS = new ObjectOutputStream(d);
        serverOOS.flush();
        ObjectInputStream serverOIS = new ObjectInputStream(a);
        this.clientOIS = clientOIS = new ObjectInputStream(c);
        this.clientOOS = clientOOS;
        this.serverOIS = serverOIS;
        this.serverOOS = serverOOS;
    }

    public void testSerialization() throws Exception {
        ServerMessage.Completion message = new ServerMessage.Completion(new CompletionMatch(Delimiter.DOUBLE_QUOTE, Completion.create((String)"pref", (String)"ix", (boolean)true)));
        this.clientOOS.writeObject(message);
        this.clientOOS.flush();
        ServerMessage after = (ServerMessage)this.serverOIS.readObject();
        System.out.println("after = " + after);
    }

    public void testPrompt() throws Exception {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(){

            public String getPrompt() {
                return "foo";
            }
        });
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        RemoteShellTestCase.assertEquals((String)"foo", (String)server.getPrompt());
        t.interrupt();
        RemoteShellTestCase.assertJoin(t);
    }

    public void testWelcome() throws Exception {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(){

            public String getWelcome() {
                return "bar";
            }
        });
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        RemoteShellTestCase.assertEquals((String)"bar", (String)server.getWelcome());
        t.interrupt();
        RemoteShellTestCase.assertJoin(t);
    }

    public void testExecute() throws Exception {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(new BaseProcessFactory(){

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    public void process(String request, ShellProcessContext processContext) throws IOException {
                        processContext.provide((Object)Text.create((CharSequence)"juu"));
                        processContext.end((ShellResponse)ShellResponse.ok());
                    }
                };
            }
        }));
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        ShellProcess process = server.createProcess("hello");
        BaseProcessContext context = BaseProcessContext.create(process);
        context.execute();
        RemoteShellTestCase.assertInstance(ShellResponse.Ok.class, context.getResponse());
        RemoteShellTestCase.assertEquals((String)"juu", (String)context.getOutput());
        t.interrupt();
        RemoteShellTestCase.assertJoin(t);
    }

    public void testClose() throws Exception {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(new BaseProcessFactory(){

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    protected ShellResponse execute(String request) {
                        return ShellResponse.close();
                    }
                };
            }
        }));
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        ShellProcess process = server.createProcess("hello");
        BaseProcessContext context = BaseProcessContext.create(process);
        context.execute();
        ShellResponse response = context.getResponse();
        RemoteShellTestCase.assertInstance(ShellResponse.Close.class, response);
        RemoteShellTestCase.assertJoin(t);
    }

    public void testRawClose() throws Exception {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(new BaseProcessFactory(){

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    protected ShellResponse execute(String request) {
                        return ShellResponse.close();
                    }
                };
            }
        }));
        t.start();
        this.serverOOS.writeObject(new ClientMessage.Execute(32, 50, ""));
        this.serverOOS.flush();
        ServerMessage.End message = (ServerMessage.End)this.serverOIS.readObject();
        RemoteShellTestCase.assertInstance(ShellResponse.Close.class, message.response);
        try {
            this.serverOIS.readObject();
            RemoteShellTestCase.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        RemoteShellTestCase.assertJoin(t);
    }

    public void testExceptionDuringRequest() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ex = new AtomicReference();
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(new BaseProcessFactory(){
            int count = 0;

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    public void process(String request, final ShellProcessContext processContext) throws IOException {
                        if (count == 0) {
                            count = 1;
                            new Thread(){

                                public void run() {
                                    try {
                                        latch.await();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    processContext.end((ShellResponse)ShellResponse.ok());
                                }
                            }.start();
                            ex.set(new RuntimeException("this is a runtime exception"));
                            throw (RuntimeException)ex.get();
                        }
                        processContext.end((ShellResponse)ShellResponse.ok());
                    }
                };
            }
        }));
        t.start();
        this.serverOOS.writeObject(new ClientMessage.Execute(32, 50, ""));
        this.serverOOS.flush();
        ServerMessage.End message = (ServerMessage.End)this.serverOIS.readObject();
        ShellResponse.Error error = RemoteShellTestCase.assertInstance(ShellResponse.Error.class, message.response);
        RemoteShellTestCase.assertEquals((Object)ErrorType.INTERNAL, (Object)error.getType());
        RemoteShellTestCase.assertInstance(Exception.class, error.getThrowable());
        RemoteShellTestCase.assertEquals((String)"this is a runtime exception", (String)error.getThrowable().getMessage());
        RemoteShellTestCase.assertEquals(Arrays.asList(((RuntimeException)ex.get()).getStackTrace()), Arrays.asList(error.getThrowable().getStackTrace()));
        latch.countDown();
        this.serverOOS.writeObject(new ClientMessage.Execute(32, 50, ""));
        this.serverOOS.flush();
        message = (ServerMessage.End)this.serverOIS.readObject();
        RemoteShellTestCase.assertInstance(ShellResponse.Ok.class, message.response);
        t.interrupt();
        RemoteShellTestCase.assertJoin(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCancel() throws Exception {
        final AtomicBoolean waiting = new AtomicBoolean();
        final CountDownLatch latch = new CountDownLatch(1);
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(new BaseProcessFactory(){

            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    public void process(String request, final ShellProcessContext processContext) throws IOException {
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                AtomicBoolean atomicBoolean = waiting;
                                synchronized (atomicBoolean) {
                                    if (waiting.get()) {
                                        waiting.notifyAll();
                                    } else {
                                        waiting.set(true);
                                    }
                                    try {
                                        waiting.wait();
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                                try {
                                    processContext.provide((Object)Text.create((CharSequence)"juu"));
                                    processContext.end((ShellResponse)ShellResponse.ok());
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                latch.countDown();
                            }
                        }.start();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void cancel() {
                        AtomicBoolean atomicBoolean = waiting;
                        synchronized (atomicBoolean) {
                            waiting.notifyAll();
                        }
                    }
                };
            }
        }));
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        ShellProcess process = server.createProcess("hello");
        final BaseProcessContext context = BaseProcessContext.create(process);
        final AtomicReference error = new AtomicReference();
        Thread u = new Thread(){

            public void run() {
                context.execute();
                ShellResponse response = context.getResponse();
                AbstractTestCase.assertInstance(ShellResponse.Cancelled.class, response);
            }
        };
        u.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                error.set(e);
            }
        });
        u.start();
        AtomicBoolean atomicBoolean = waiting;
        synchronized (atomicBoolean) {
            if (!waiting.get()) {
                waiting.set(true);
                waiting.wait();
            }
        }
        process.cancel();
        latch.await();
        t.interrupt();
        RemoteShellTestCase.assertJoin(t);
        RemoteShellTestCase.assertJoin(u);
        if (error.get() != null) {
            throw RemoteShellTestCase.failure((Throwable)error.get());
        }
    }

    public void testComplete() {
        ClientProcessor t = new ClientProcessor(this.clientOIS, this.clientOOS, new BaseShell(){

            public CompletionMatch complete(String prefix) {
                return new CompletionMatch(Delimiter.DOUBLE_QUOTE, Completion.create((String)prefix, (String)"ix", (boolean)true));
            }
        });
        t.start();
        ServerAutomaton server = new ServerAutomaton(this.serverOOS, this.serverOIS);
        CompletionMatch completion = server.complete("pref");
        RemoteShellTestCase.assertEquals((Object)Delimiter.DOUBLE_QUOTE, (Object)completion.getDelimiter());
        Completion value = completion.getValue();
        RemoteShellTestCase.assertEquals((String)"pref", (String)value.getPrefix());
        RemoteShellTestCase.assertEquals((int)1, (int)value.getSize());
        RemoteShellTestCase.assertEquals(Collections.singleton("ix"), (Object)value.getValues());
        RemoteShellTestCase.assertEquals((Object)Boolean.TRUE, (Object)value.get("ix"));
        t.interrupt();
        RemoteShellTestCase.assertJoin(t);
    }

    static class ClientProcessor
    extends Thread {
        final ObjectInputStream in;
        final ObjectOutputStream out;
        final Shell shell;

        ClientProcessor(ObjectInputStream in, ObjectOutputStream out, Shell shell) {
            this.in = in;
            this.out = out;
            this.shell = shell;
        }

        public void run() {
            ClientAutomaton client = new ClientAutomaton(this.out, this.in, this.shell);
            client.run();
        }
    }
}

