/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import junit.framework.TestCase;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.Style;

public class AnsiBuilderTestCase
extends TestCase {
    public void testReset() throws Exception {
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[0m", (Object)Style.reset.toAnsiSequence());
    }

    public void testDecoration() throws Exception {
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[5m", (Object)Style.style((Decoration)Decoration.blink, null, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[25m", (Object)Style.style((Decoration)Decoration.blink_off, null, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[1m", (Object)Style.style((Decoration)Decoration.bold, null, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[22m", (Object)Style.style((Decoration)Decoration.bold_off, null, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[4m", (Object)Style.style((Decoration)Decoration.underline, null, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[24m", (Object)Style.style((Decoration)Decoration.underline_off, null, null).toAnsiSequence());
    }

    public void testForeground() throws Exception {
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[30m", (Object)Style.style(null, (Color)Color.black, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[34m", (Object)Style.style(null, (Color)Color.blue, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[36m", (Object)Style.style(null, (Color)Color.cyan, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[32m", (Object)Style.style(null, (Color)Color.green, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[35m", (Object)Style.style(null, (Color)Color.magenta, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[31m", (Object)Style.style(null, (Color)Color.red, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[33m", (Object)Style.style(null, (Color)Color.yellow, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[37m", (Object)Style.style(null, (Color)Color.white, null).toAnsiSequence());
    }

    public void testBackground() throws Exception {
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[40m", (Object)Style.style(null, null, (Color)Color.black).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[44m", (Object)Style.style(null, null, (Color)Color.blue).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[46m", (Object)Style.style(null, null, (Color)Color.cyan).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[42m", (Object)Style.style(null, null, (Color)Color.green).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[45m", (Object)Style.style(null, null, (Color)Color.magenta).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[41m", (Object)Style.style(null, null, (Color)Color.red).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[43m", (Object)Style.style(null, null, (Color)Color.yellow).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[47m", (Object)Style.style(null, null, (Color)Color.white).toAnsiSequence());
    }

    public void testMany() throws Exception {
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[34;40m", (Object)Style.style(null, (Color)Color.blue, (Color)Color.black).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[4;40m", (Object)Style.style((Decoration)Decoration.underline, null, (Color)Color.black).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[4;34m", (Object)Style.style((Decoration)Decoration.underline, (Color)Color.blue, null).toAnsiSequence());
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[4;34;40m", (Object)Style.style((Decoration)Decoration.underline, (Color)Color.blue, (Color)Color.black).toAnsiSequence());
    }

    public void testFluent() throws Exception {
        Style.Composite style = Color.red.bg().bold().underline().fg(Color.blue);
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[1;4;34;41m", (Object)style.toAnsiSequence());
        style = style.bold(Boolean.valueOf(false));
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[22;4;34;41m", (Object)style.toAnsiSequence());
        style = style.bold(null);
        AnsiBuilderTestCase.assertEquals((Object)"\u001b[4;34;41m", (Object)style.toAnsiSequence());
    }
}

