/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs;

import java.util.Iterator;
import junit.framework.TestCase;
import org.crsh.vfs.Path;

public class PathTestCase
extends TestCase {
    public void testPath() throws Exception {
        this.assertSamePath("/", true, new String[0]);
        this.assertSamePath("//", true, new String[0]);
        this.assertSamePath("/a", false, "a");
        this.assertSamePath("//a", false, "a");
        this.assertSamePath("/a/", true, "a");
        this.assertSamePath("//a/", true, "a");
        this.assertSamePath("/a/b", false, "a", "b");
        this.assertSamePath("/a//b", false, "a", "b");
        this.assertSamePath("//a/b", false, "a", "b");
        this.assertSamePath("/a/b/", true, "a", "b");
        this.assertSamePath("/a//b/", true, "a", "b");
        this.assertSamePath("//a/b/", true, "a", "b");
        this.assertSamePath("//a/b//", true, "a", "b");
    }

    private void assertSamePath(String s, boolean dir, String ... expectedNames) {
        Path path = Path.get((String)s);
        PathTestCase.assertEquals((boolean)dir, (boolean)path.isDir());
        PathTestCase.assertEquals((int)path.getSize(), (int)expectedNames.length);
        Iterator names = path.iterator();
        for (int i = 0; i < expectedNames.length; ++i) {
            PathTestCase.assertEquals((String)expectedNames[i], (String)((String)names.next()));
        }
    }
}

