/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs.spi.url;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import org.crsh.util.Safe;
import org.crsh.vfs.spi.url.InputStreamResolver;
import org.crsh.vfs.spi.url.ZipIterator;

public abstract class Node {
    final String name;

    protected Node(String name) {
        this.name = name;
    }

    static class File
    extends Node {
        final InputStreamResolver resolver;
        final long lastModified;

        File(String name, InputStreamResolver url, long lastModified) {
            super(name);
            this.resolver = url;
            this.lastModified = lastModified;
        }
    }

    static class Dir
    extends Node {
        HashMap<String, Node> children = new HashMap();

        Dir() {
            this("");
        }

        private Dir(String name) {
            super(name);
        }

        void merge(ClassLoader loader) throws IOException, URISyntaxException {
            Enumeration<URL> i = loader.getResources("");
            while (i.hasMoreElements()) {
                URL url = i.nextElement();
                this.merge(url);
            }
            ArrayList<URL> items = Collections.list(loader.getResources("META-INF/MANIFEST.MF"));
            for (URL item : items) {
                if (!"jar".equals(item.getProtocol())) continue;
                String path = item.getPath();
                int pos = path.indexOf("!/");
                URL url = new URL(path.substring(0, pos));
                this.merge(url);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void merge(URL url) throws IOException, URISyntaxException {
            if (url.getProtocol().equals("file")) {
                try {
                    java.io.File f = new java.io.File(url.toURI());
                    if (f.isDirectory()) {
                        this.merge(f);
                    } else if (f.getName().endsWith(".jar")) {
                        this.merge(new URL("jar:" + url + "!/"));
                    }
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
            if (url.getProtocol().equals("jar")) {
                int pos = url.getPath().lastIndexOf("!/");
                URL jarURL = new URL(url.getPath().substring(0, pos));
                String path = url.getPath().substring(pos + 2);
                ZipIterator i = ZipIterator.create(jarURL);
                try {
                    while (i.hasNext()) {
                        ZipEntry entry = i.next();
                        if (!entry.getName().startsWith(path)) continue;
                        this.add(url, entry.getName().substring(path.length()), i.open());
                    }
                }
                finally {
                    Safe.close(i);
                }
            } else if (url.getPath().endsWith(".jar")) {
                this.merge(new URL("jar:" + url + "!/"));
            }
        }

        private void merge(java.io.File f) throws IOException {
            for (final java.io.File file : f.listFiles()) {
                String name = file.getName();
                Node child = this.children.get(name);
                if (file.isDirectory()) {
                    if (child == null) {
                        Dir dir = new Dir(name);
                        dir.merge(file);
                        this.children.put(name, dir);
                        continue;
                    }
                    if (!(child instanceof Dir)) continue;
                    ((Dir)child).merge(file);
                    continue;
                }
                if (child != null) continue;
                this.children.put(name, new File(name, new InputStreamResolver(){

                    public InputStream open() throws IOException {
                        return new FileInputStream(file);
                    }
                }, file.lastModified()));
            }
        }

        private void add(URL baseURL, String entryName, InputStreamResolver resolver) throws IOException {
            if (entryName.length() > 0 && entryName.charAt(entryName.length() - 1) != '/') {
                this.add(baseURL, 0, entryName, 1L, resolver);
            }
        }

        private void add(URL baseURL, int index, String entryName, long lastModified, InputStreamResolver resolver) throws IOException {
            int next = entryName.indexOf(47, index);
            if (next == -1) {
                String name = entryName.substring(index);
                Node child = this.children.get(name);
                if (child == null) {
                    this.children.put(name, new File(name, resolver, lastModified));
                }
            } else {
                String name = entryName.substring(index, next);
                Node child = this.children.get(name);
                if (child == null) {
                    Dir dir = new Dir(name);
                    this.children.put(name, dir);
                    dir.add(baseURL, next + 1, entryName, lastModified, resolver);
                } else if (child instanceof Dir) {
                    ((Dir)child).add(baseURL, next + 1, entryName, lastModified, resolver);
                }
            }
        }
    }
}

