/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.async;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.crsh.AbstractTestCase;
import org.crsh.BaseProcess;
import org.crsh.BaseProcessContext;
import org.crsh.BaseProcessFactory;
import org.crsh.BaseShell;
import org.crsh.CommandQueue;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.async.AsyncProcess;
import org.crsh.shell.impl.async.AsyncShell;
import org.crsh.shell.impl.async.Status;

public class CancellationTestCase
extends AbstractTestCase {
    public void testEvaluating() throws Exception {
        final AtomicReference failure = new AtomicReference();
        final AtomicInteger cancelCount = new AtomicInteger(0);
        final CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        BaseProcessFactory factory = new BaseProcessFactory(){

            @Override
            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    @Override
                    protected ShellResponse execute(String request) {
                        latch1.countDown();
                        try {
                            latch2.await();
                        }
                        catch (InterruptedException e) {
                            failure.set(e);
                        }
                        return ShellResponse.ok();
                    }

                    @Override
                    public void cancel() {
                        cancelCount.getAndIncrement();
                    }
                };
            }
        };
        BaseShell shell = new BaseShell(factory);
        CommandQueue commands = new CommandQueue();
        AsyncShell asyncShell = new AsyncShell((Executor)commands, (Shell)shell);
        BaseProcessContext ctx = BaseProcessContext.create((Shell)asyncShell, "foo").execute();
        CancellationTestCase.assertEquals((Object)Status.QUEUED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        CancellationTestCase.assertEquals((int)0, (int)cancelCount.get());
        CancellationTestCase.assertEquals((int)1, (int)commands.getSize());
        Future<Runnable> future = commands.executeAsync();
        latch1.await();
        CancellationTestCase.assertEquals((Object)Status.EVALUATING, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        CancellationTestCase.assertEquals((int)0, (int)cancelCount.get());
        ctx.getProcess().cancel();
        CancellationTestCase.assertEquals((Object)Status.CANCELED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        CancellationTestCase.assertEquals((int)1, (int)cancelCount.get());
        ctx.getProcess().cancel();
        CancellationTestCase.assertEquals((Object)Status.CANCELED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        CancellationTestCase.assertEquals((int)1, (int)cancelCount.get());
        latch2.countDown();
        future.get();
        CancellationTestCase.assertEquals(ShellResponse.Cancelled.class, ctx.getResponse().getClass());
        CancellationTestCase.assertEquals((Object)Status.TERMINATED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        CancellationTestCase.assertEquals((int)1, (int)cancelCount.get());
        CancellationTestCase.safeFail((Throwable)failure.get());
    }

    public void testQueued() throws Exception {
        final AtomicReference failure = new AtomicReference();
        BaseProcessFactory factory = new BaseProcessFactory(){

            @Override
            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    @Override
                    protected ShellResponse execute(String request) {
                        failure.set(AbstractTestCase.failure("Was not exepecting request"));
                        return ShellResponse.ok();
                    }

                    @Override
                    public void cancel() {
                        failure.set(AbstractTestCase.failure("Was not exepecting cancel"));
                    }
                };
            }
        };
        BaseShell shell = new BaseShell(factory);
        CommandQueue commands = new CommandQueue();
        AsyncShell asyncShell = new AsyncShell((Executor)commands, (Shell)shell);
        BaseProcessContext ctx = BaseProcessContext.create((Shell)asyncShell, "foo").execute();
        CancellationTestCase.assertEquals((Object)Status.QUEUED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        CancellationTestCase.assertEquals((int)1, (int)commands.getSize());
        ctx.getProcess().cancel();
        CancellationTestCase.assertEquals((Object)Status.CANCELED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        Future<Runnable> future = commands.executeAsync();
        future.get();
        CancellationTestCase.assertEquals((Object)Status.TERMINATED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        CancellationTestCase.assertEquals(ShellResponse.Cancelled.class, ctx.getResponse().getClass());
        CancellationTestCase.safeFail((Throwable)failure.get());
    }
}

