/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.async;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.crsh.AbstractTestCase;
import org.crsh.BaseProcess;
import org.crsh.BaseProcessContext;
import org.crsh.BaseProcessFactory;
import org.crsh.BaseShell;
import org.crsh.CommandQueue;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.async.AsyncProcess;
import org.crsh.shell.impl.async.AsyncShell;
import org.crsh.shell.impl.async.Status;

public class ShutdownTestCase
extends AbstractTestCase {
    public void testCreate() throws Exception {
        BaseShell shell = new BaseShell();
        CommandQueue commands = new CommandQueue();
        AsyncShell asyncShell = new AsyncShell((Executor)commands, (Shell)shell);
        asyncShell.close();
        try {
            asyncShell.createProcess("foo");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    public void testExecute() throws Exception {
        BaseShell shell = new BaseShell();
        CommandQueue commands = new CommandQueue();
        AsyncShell asyncShell = new AsyncShell((Executor)commands, (Shell)shell);
        BaseProcessContext ctx = BaseProcessContext.create((Shell)asyncShell, "foo");
        asyncShell.close();
        ctx.execute();
        ShutdownTestCase.assertEquals((Object)Status.TERMINATED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        ShutdownTestCase.assertEquals(ShellResponse.Cancelled.class, ctx.getResponse().getClass());
        ShutdownTestCase.assertEquals((int)0, (int)commands.getSize());
    }

    public void testCancel() throws Exception {
        final AtomicReference failure = new AtomicReference();
        final CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        BaseProcessFactory factory = new BaseProcessFactory(){

            @Override
            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    @Override
                    protected ShellResponse execute(String request) {
                        latch1.countDown();
                        try {
                            latch2.await();
                        }
                        catch (InterruptedException e) {
                            failure.set(e);
                        }
                        return ShellResponse.ok();
                    }

                    @Override
                    public void cancel() {
                        latch2.countDown();
                    }
                };
            }
        };
        BaseShell shell = new BaseShell(factory);
        CommandQueue commands = new CommandQueue();
        AsyncShell asyncShell = new AsyncShell((Executor)commands, (Shell)shell);
        BaseProcessContext ctx = BaseProcessContext.create((Shell)asyncShell, "foo").execute();
        Future<Runnable> future = commands.executeAsync();
        latch1.await();
        ShutdownTestCase.assertEquals((Object)Status.EVALUATING, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        asyncShell.close();
        ShutdownTestCase.assertEquals((Object)Status.CANCELED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        ShutdownTestCase.assertEquals(ShellResponse.Cancelled.class, ctx.getResponse().getClass());
    }
}

