/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.util.ArrayList;
import java.util.List;
import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.BorderStyle;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.Layout;
import org.crsh.text.ui.Overflow;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.TableRenderer;

public class TableElement
extends Element {
    ArrayList<RowElement> rows = new ArrayList();
    protected BorderStyle border;
    protected BorderStyle separator;
    private Overflow overflow;
    protected Layout columnLayout;
    protected Layout rowLayout;
    private int leftCellPadding;
    private int rightCellPadding;

    public TableElement() {
        this(Layout.flow(), Layout.flow());
    }

    public TableElement(int ... columns) {
        this(Layout.flow(), Layout.weighted(columns));
    }

    public TableElement(int[] rows, int[] columns) {
        this(Layout.weighted(rows), Layout.weighted(columns));
    }

    private TableElement(Layout rowLayout, Layout columnLayout) {
        this.rowLayout = rowLayout;
        this.columnLayout = columnLayout;
        this.border = null;
        this.separator = null;
        this.overflow = Overflow.WRAP;
        this.leftCellPadding = 0;
        this.rightCellPadding = 0;
    }

    public TableElement add(RowElement row) {
        this.rows.add(row);
        return this;
    }

    public Layout getColumnLayout() {
        return this.columnLayout;
    }

    public void setColumnLayout(Layout columnLayout) {
        if (columnLayout == null) {
            throw new NullPointerException("Column layout cannot be null");
        }
        this.columnLayout = columnLayout;
    }

    public Layout getRowLayout() {
        return this.rowLayout;
    }

    public void setRowLayout(Layout rowLayout) {
        if (rowLayout == null) {
            throw new NullPointerException("Row layout cannot be null");
        }
        this.rowLayout = rowLayout;
    }

    @Override
    public Renderer renderer() {
        return new TableRenderer(this);
    }

    public TableElement withColumnLayout(Layout columnLayout) {
        this.setColumnLayout(columnLayout);
        return this;
    }

    public TableElement withRowLayout(Layout rowLayout) {
        this.setRowLayout(rowLayout);
        return this;
    }

    public List<RowElement> getRows() {
        return this.rows;
    }

    public BorderStyle getBorder() {
        return this.border;
    }

    public void setBorder(BorderStyle border) {
        this.border = border;
    }

    public TableElement border(BorderStyle border) {
        this.setBorder(border);
        return this;
    }

    public BorderStyle getSeparator() {
        return this.separator;
    }

    public void setSeparator(BorderStyle separator) {
        this.separator = separator;
    }

    public TableElement collapse() {
        this.setSeparator(null);
        return this;
    }

    public TableElement separator(BorderStyle separator) {
        this.setSeparator(separator);
        return this;
    }

    public void setOverflow(Overflow overflow) {
        this.overflow = overflow;
    }

    public final Overflow getOverflow() {
        return this.overflow;
    }

    public TableElement overflow(Overflow overflow) {
        this.setOverflow(overflow);
        return this;
    }

    public int getLeftCellPadding() {
        return this.leftCellPadding;
    }

    public void setLeftCellPadding(int leftCellPadding) {
        if (leftCellPadding < 0) {
            throw new IllegalArgumentException("No negative cell padding left accepted");
        }
        this.leftCellPadding = leftCellPadding;
    }

    public TableElement leftCellPadding(int leftCellPadding) {
        this.setLeftCellPadding(leftCellPadding);
        return this;
    }

    public int getRightCellPadding() {
        return this.rightCellPadding;
    }

    public void setRightCellPadding(int rightCellPadding) {
        if (rightCellPadding < 0) {
            throw new IllegalArgumentException("No negative cell padding right accepted");
        }
        this.rightCellPadding = rightCellPadding;
    }

    public TableElement rightCellPadding(int rightCellPadding) {
        this.setRightCellPadding(rightCellPadding);
        return this;
    }

    @Override
    public TableElement style(Style.Composite style) {
        return (TableElement)super.style(style);
    }
}

