/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.remoting;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.crsh.AbstractTestCase;
import org.crsh.shell.ErrorType;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.remoting.ServerMessage;

public class ServerMessageTestCase
extends AbstractTestCase {
    public void testErrorResponseSerialiation() throws Exception {
        ShellResponse.Error expectedResponse = ShellResponse.error((ErrorType)ErrorType.EVALUATION, (String)"hell", (Throwable)new MyException());
        ServerMessage.End expectedMessage = new ServerMessage.End((ShellResponse)expectedResponse);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(expectedMessage);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        ServerMessage.End message = ServerMessageTestCase.assertInstance(ServerMessage.End.class, o);
        ShellResponse.Error response = ServerMessageTestCase.assertInstance(ShellResponse.Error.class, message.response);
        ServerMessageTestCase.assertEquals((String)expectedResponse.getMessage(), (String)response.getMessage());
        ServerMessageTestCase.assertEquals(Arrays.asList(expectedResponse.getThrowable().getStackTrace()), Arrays.asList(response.getThrowable().getStackTrace()));
    }

    public static class MyException
    extends Throwable {
        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            throw new ClassNotFoundException("Simulates a class not found");
        }
    }
}

