/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.remoting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.shell.ErrorType;
import org.crsh.shell.ShellResponse;

public class ServerMessage
implements Serializable {

    public static class End
    extends ServerMessage {
        public ShellResponse response;

        public End(ShellResponse response) {
            if (response == null) {
                throw new NullPointerException("No null response accepted");
            }
            this.response = response;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            if (this.response instanceof ShellResponse.Error) {
                oos.writeBoolean(false);
                ShellResponse.Error error = (ShellResponse.Error)this.response;
                oos.writeObject((Object)error.getType());
                oos.writeObject(error.getMessage());
                oos.writeObject(error.getThrowable().getMessage());
                oos.writeObject(error.getThrowable().getStackTrace());
            } else {
                oos.writeBoolean(true);
                oos.writeObject(this.response);
            }
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            if (ois.readBoolean()) {
                this.response = (ShellResponse)ois.readObject();
            } else {
                ErrorType type = (ErrorType)((Object)ois.readObject());
                String message = (String)ois.readObject();
                String errorMessage = (String)ois.readObject();
                StackTraceElement[] errorTrace = (StackTraceElement[])ois.readObject();
                Exception ex = new Exception(errorMessage);
                ex.setStackTrace(errorTrace);
                this.response = ShellResponse.error(type, message, ex);
            }
        }
    }

    public static class Flush
    extends ServerMessage {
    }

    public static class Chunk
    extends ServerMessage {
        public final org.crsh.text.Chunk payload;

        public Chunk(org.crsh.text.Chunk payload) {
            this.payload = payload;
        }
    }

    public static class ReadLine
    extends ServerMessage {
    }

    public static class GetSize
    extends ServerMessage {
    }

    public static class UseAlternateBuffer
    extends ServerMessage {
    }

    public static class UseMainBuffer
    extends ServerMessage {
    }

    public static class Completion
    extends ServerMessage {
        public final CompletionMatch value;

        public Completion(CompletionMatch value) {
            this.value = value;
        }
    }

    public static class Prompt
    extends ServerMessage {
        public final String value;

        public Prompt(String value) {
            this.value = value;
        }
    }

    public static class Welcome
    extends ServerMessage {
        public final String value;

        public Welcome(String value) {
            this.value = value;
        }
    }
}

