/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.ArrayList;
import java.util.List;
import org.crsh.shell.AbstractCommandTestCase;
import org.crsh.text.formatter.BindingRenderable;

public class JNDICommandTestCase
extends AbstractCommandTestCase {
    private String defaultFactory;
    public static List<BindingRenderable.BindingData> output = new ArrayList<BindingRenderable.BindingData>();
    private final String consume_command = "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}";

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.defaultFactory == null) {
            System.clearProperty("java.naming.factory.initial");
        } else {
            System.setProperty("java.naming.factory.initial", this.defaultFactory);
        }
    }

    public void testSimple() throws Exception {
        this.setFactory("org.crsh.shell.factory.SimpleInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find | consume_command");
        JNDICommandTestCase.assertEquals((int)2, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"Foo", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
        JNDICommandTestCase.assertEquals((String)"java:global/Foo", (String)JNDICommandTestCase.output.get((int)1).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)1).type);
    }

    public void testNested() throws Exception {
        this.setFactory("org.crsh.shell.factory.NestedInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find | consume_command");
        JNDICommandTestCase.assertEquals((int)3, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"java:global/Foo", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
        JNDICommandTestCase.assertEquals((String)"java:global/Foo2", (String)JNDICommandTestCase.output.get((int)1).name);
        JNDICommandTestCase.assertEquals((String)"Bar2", (String)JNDICommandTestCase.output.get((int)1).type);
        JNDICommandTestCase.assertEquals((String)"java:global/Foo2/Foo", (String)JNDICommandTestCase.output.get((int)2).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)2).type);
    }

    public void testError() throws Exception {
        this.setFactory("org.crsh.shell.factory.ErrorInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find | consume_command");
        JNDICommandTestCase.assertEquals((int)2, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"Empty", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Empty2", (String)JNDICommandTestCase.output.get((int)0).type);
        JNDICommandTestCase.assertEquals((String)"java:module/Module", (String)JNDICommandTestCase.output.get((int)1).name);
        JNDICommandTestCase.assertEquals((String)"Module2", (String)JNDICommandTestCase.output.get((int)1).type);
    }

    public void testFilter() throws Exception {
        this.setFactory("org.crsh.shell.factory.TypedInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find -f java.lang.String | consume_command");
        JNDICommandTestCase.assertEquals((int)1, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"String", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
    }

    public void testFilterMany() throws Exception {
        this.setFactory("org.crsh.shell.factory.TypedInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find -f java.lang.String -f java.util.List | consume_command");
        JNDICommandTestCase.assertEquals((int)2, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"String", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
        JNDICommandTestCase.assertEquals((String)"ArrayList", (String)JNDICommandTestCase.output.get((int)1).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)1).type);
    }

    public void testFilterInterface() throws Exception {
        this.setFactory("org.crsh.shell.factory.TypedInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find -f java.util.List | consume_command");
        JNDICommandTestCase.assertEquals((int)1, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"ArrayList", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
    }

    public void testFilterSuperType() throws Exception {
        this.setFactory("org.crsh.shell.factory.TypedInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find -f java.util.AbstractList | consume_command");
        JNDICommandTestCase.assertEquals((int)1, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"ArrayList", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
    }

    public void testNameExact() throws Exception {
        this.setFactory("org.crsh.shell.factory.SimpleInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find -n Foo | consume_command");
        JNDICommandTestCase.assertEquals((int)1, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"Foo", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
    }

    public void testNameBegin() throws Exception {
        this.setFactory("org.crsh.shell.factory.SimpleInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find -n F* | consume_command");
        JNDICommandTestCase.assertEquals((int)1, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"Foo", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
    }

    public void testNameEnd() throws Exception {
        this.setFactory("org.crsh.shell.factory.SimpleInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find -n *o | consume_command");
        JNDICommandTestCase.assertEquals((int)2, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"Foo", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
        JNDICommandTestCase.assertEquals((String)"java:global/Foo", (String)JNDICommandTestCase.output.get((int)1).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)1).type);
    }

    public void testNameNoBeginEnd() throws Exception {
        this.setFactory("org.crsh.shell.factory.SimpleInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find -n *global* | consume_command");
        JNDICommandTestCase.assertEquals((int)1, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"java:global/Foo", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
    }

    public void testNameWildcard() throws Exception {
        this.setFactory("org.crsh.shell.factory.SimpleInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find -n java:*/Foo | consume_command");
        JNDICommandTestCase.assertEquals((int)1, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"java:global/Foo", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
    }

    public void testNameWildcardBeginEnd() throws Exception {
        this.setFactory("org.crsh.shell.factory.SimpleInitialContextFactory");
        output.clear();
        this.lifeCycle.bind("consume_command", "class consume_command {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.BindingRenderable.BindingData, Object>() {\npublic void provide(org.crsh.text.formatter.BindingRenderable.BindingData element) {\norg.crsh.shell.JNDICommandTestCase.output.add(element)\n}\n}\n}\n}");
        this.assertOk("jndi find -n *:*/* | consume_command");
        JNDICommandTestCase.assertEquals((int)1, (int)output.size());
        JNDICommandTestCase.assertEquals((String)"java:global/Foo", (String)JNDICommandTestCase.output.get((int)0).name);
        JNDICommandTestCase.assertEquals((String)"Bar", (String)JNDICommandTestCase.output.get((int)0).type);
    }

    private void setFactory(String name) {
        this.defaultFactory = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", name);
    }
}

