/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.lang.groovy.shell;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.ShellCommand;
import org.crsh.lang.CommandManager;
import org.crsh.lang.groovy.command.GroovyScript;
import org.crsh.lang.groovy.command.GroovyScriptCommand;
import org.crsh.lang.groovy.shell.AbstractClassManager;
import org.crsh.lang.groovy.shell.ClassManager;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.ResourceKind;

public class GroovyCommandManager
extends CommandManager {
    static final Logger log = Logger.getLogger(GroovyCommandManager.class.getName());
    final PluginContext context;
    final AbstractClassManager<? extends ShellCommand> commandManager;
    final AbstractClassManager<? extends GroovyScript> scriptManager;

    public GroovyCommandManager(PluginContext context) {
        this.context = context;
        this.commandManager = new ClassManager<ShellCommand>(context, ResourceKind.COMMAND, ShellCommand.class, GroovyScriptCommand.class);
        this.scriptManager = new ClassManager<GroovyScript>(context, ResourceKind.LIFECYCLE, GroovyScript.class, GroovyScript.class);
    }

    @Override
    public String doCallBack(HashMap<String, Object> session, String name, String defaultValue) {
        return this.eval(session, name, defaultValue);
    }

    @Override
    public void init(HashMap<String, Object> session) {
        try {
            GroovyScript login = this.getLifeCycle(session, "login");
            if (login != null) {
                login.setBinding(new Binding(session));
                login.run();
            }
        }
        catch (NoSuchCommandException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy(HashMap<String, Object> session) {
        try {
            GroovyScript logout = this.getLifeCycle(session, "logout");
            if (logout != null) {
                logout.setBinding(new Binding(session));
                logout.run();
            }
        }
        catch (NoSuchCommandException e) {
            e.printStackTrace();
        }
    }

    public GroovyShell getGroovyShell(HashMap<String, Object> session) {
        GroovyShell shell = (GroovyShell)session.get("shell");
        if (shell == null) {
            CompilerConfiguration config = new CompilerConfiguration();
            config.setRecompileGroovySource(true);
            config.setScriptBaseClass(GroovyScriptCommand.class.getName());
            shell = new GroovyShell(this.context.getLoader(), new Binding(session), config);
            session.put("shell", shell);
        }
        return shell;
    }

    private String eval(HashMap<String, Object> session, String name, String def) {
        try {
            GroovyShell shell = this.getGroovyShell(session);
            Object ret = shell.evaluate("return " + name + ";");
            if (ret instanceof Closure) {
                log.log(Level.FINEST, "Invoking " + name + " closure");
                Closure c = (Closure)ret;
                ret = c.call();
            } else if (ret == null) {
                log.log(Level.FINEST, "No " + name + " will use empty");
                return def;
            }
            return String.valueOf(ret);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not get a " + name + " message, will use empty", e);
            return def;
        }
    }

    public GroovyScript getLifeCycle(HashMap<String, Object> session, String name) throws NoSuchCommandException, NullPointerException {
        Class<? extends GroovyScript> scriptClass = this.scriptManager.getClass(name);
        if (scriptClass != null) {
            GroovyScript script = (GroovyScript)InvokerHelper.createScript(scriptClass, new Binding(session));
            script.setBinding(new Binding(session));
            return script;
        }
        return null;
    }

    @Override
    public ShellCommand getCommand(String name) throws NoSuchCommandException, NullPointerException {
        return this.commandManager.getInstance(name);
    }
}

