/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.crsh.AbstractTestCase;
import org.crsh.io.Consumer;
import org.crsh.io.Producer;

public class ProducerTestCase
extends AbstractTestCase {
    public void testSuperType() throws IOException {
        ConsumerImpl<Object> consumer = new ConsumerImpl<Object>(Object.class);
        ProducerImpl<String, ConsumerImpl<Object>> producer = new ProducerImpl<String, ConsumerImpl<Object>>(String.class);
        producer.open(consumer);
        producer.provide("foo");
        ProducerTestCase.assertEquals(Arrays.asList("foo"), consumer);
    }

    public void testSameType() throws IOException {
        ConsumerImpl<String> consumer = new ConsumerImpl<String>(String.class);
        ProducerImpl<String, ConsumerImpl<String>> producer = new ProducerImpl<String, ConsumerImpl<String>>(String.class);
        producer.open(consumer);
        producer.provide("foo");
        ProducerTestCase.assertEquals(Arrays.asList("foo"), consumer);
    }

    static class ProducerImpl<P, C extends Consumer<? super P>>
    implements Producer<P, C> {
        private final Class<P> type;
        private C consumer;

        ProducerImpl(Class<P> type) {
            this.type = type;
            this.consumer = null;
        }

        public Class<P> getProducedType() {
            return this.type;
        }

        public void open(C consumer) {
            this.consumer = consumer;
        }

        public void provide(P product) throws IOException {
            this.consumer.provide(product);
        }

        public void close() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class ConsumerImpl<C>
    extends LinkedList<C>
    implements Consumer<C> {
        private final Class<C> type;

        ConsumerImpl(Class<C> type) {
            this.type = type;
        }

        public Class<C> getConsumedType() {
            return this.type;
        }

        public void provide(C element) throws IOException {
            this.add(element);
        }

        public void flush() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

