/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.lang.script;

import junit.framework.TestCase;
import org.crsh.command.SyntaxException;
import org.crsh.lang.script.PipeLineFactory;
import org.crsh.lang.script.PipeLineParser;

public class ParserTestCase
extends TestCase {
    public void testEmpty() {
        ParserTestCase.assertNull((Object)new PipeLineParser((CharSequence)"").parse());
    }

    public void testCommand() {
        PipeLineParser p = new PipeLineParser((CharSequence)"a");
        PipeLineFactory e = p.parse();
        ParserTestCase.assertEquals((String)"a", (String)e.getLine());
        ParserTestCase.assertNull((Object)e.getNext());
    }

    public void testPipe() {
        PipeLineParser p = new PipeLineParser((CharSequence)"a|b");
        PipeLineFactory e = p.parse();
        ParserTestCase.assertEquals((String)"a", (String)e.getLine());
        ParserTestCase.assertEquals((String)"b", (String)e.getNext().getLine());
        ParserTestCase.assertNull((Object)e.getNext().getNext());
    }

    public void testSyntaxException() {
        this.assertSyntaxException("|");
        this.assertSyntaxException("a|");
    }

    private void assertSyntaxException(String s) {
        try {
            new PipeLineParser((CharSequence)s).parse();
            ParserTestCase.fail();
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
    }
}

