/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import org.crsh.AbstractTestCase;
import org.crsh.auth.SimpleAuthenticationPlugin;
import org.crsh.plugin.Property;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.PropertyManager;

public class PropertyManagerTestCase
extends AbstractTestCase {
    PropertyDescriptor<Foo> FOO = new PropertyDescriptor<Foo>(Foo.class, "foo", null, "the foo"){

        protected Foo doParse(String s) throws Exception {
            throw new UnsupportedOperationException();
        }
    };
    Foo foo = new Foo();

    public void testResolveProperty() {
        PropertyManager mgr = new PropertyManager();
        mgr.setProperty(this.FOO, (Object)this.foo);
        PropertyManagerTestCase.assertEquals((Object)this.foo, (Object)mgr.resolvePropertyValue(this.FOO));
        Property property = mgr.resolveProperty(this.FOO);
        PropertyManagerTestCase.assertEquals((Object)this.foo, (Object)property.getValue());
        Property asInteger = mgr.resolveProperty("foo", Foo.class);
        PropertyManagerTestCase.assertEquals((Object)this.foo, (Object)asInteger.getValue());
        Property asObject = mgr.resolveProperty("foo", Object.class);
        PropertyManagerTestCase.assertEquals((Object)this.foo, (Object)asObject.getValue());
    }

    public void testGetProperty() {
        PropertyManager mgr = new PropertyManager();
        mgr.setProperty(this.FOO, (Object)this.foo);
        Property property = mgr.getProperty(this.FOO);
        PropertyManagerTestCase.assertEquals((Object)this.foo, (Object)property.getValue());
        Property asInteger = mgr.getProperty("foo", Foo.class);
        PropertyManagerTestCase.assertEquals((Object)this.foo, (Object)asInteger.getValue());
        Property asObject = mgr.getProperty("foo", Object.class);
        PropertyManagerTestCase.assertNull((Object)asObject);
    }

    public void testDisplayValue() {
        PropertyManager mgr = new PropertyManager();
        mgr.setProperty(PropertyDescriptor.VFS_REFRESH_PERIOD, (Object)4);
        Property property = mgr.getProperty(PropertyDescriptor.VFS_REFRESH_PERIOD);
        PropertyManagerTestCase.assertEquals((String)"4", (String)property.getDisplayValue());
        mgr.setProperty(SimpleAuthenticationPlugin.SIMPLE_PASSWORD, (Object)"the_password");
        Property secretProperty = mgr.getProperty(SimpleAuthenticationPlugin.SIMPLE_PASSWORD);
        PropertyManagerTestCase.assertEquals((String)"*****", (String)secretProperty.getDisplayValue());
        PropertyManagerTestCase.assertEquals((String)"the_password", (String)((String)secretProperty.getValue()));
    }

    class Foo {
        Foo() {
        }
    }
}

