/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.processor.term;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executors;
import org.crsh.AbstractTestCase;
import org.crsh.processor.term.AbstractProcessorTestCase;
import org.crsh.processor.term.Processor;
import org.crsh.processor.term.SyncShell;
import org.crsh.processor.term.SyncTerm;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.impl.async.AsyncShell;
import org.crsh.term.Term;
import org.crsh.term.TermEvent;

public class AsyncProcessorTestCase
extends AbstractProcessorTestCase {
    @Override
    protected SyncShell createShell() {
        return new SyncShell();
    }

    @Override
    protected SyncTerm createTerm() {
        return new SyncTerm();
    }

    @Override
    protected Processor createProcessor(SyncTerm term, SyncShell shell) {
        AsyncShell async = new AsyncShell(Executors.newSingleThreadExecutor(), (Shell)shell);
        return new Processor((Term)term, (Shell)async);
    }

    @Override
    protected int getBarrierSize() {
        return 2;
    }

    public void testCloseHangingProcess() throws Exception {
        final CyclicBarrier syncA = new CyclicBarrier(2);
        final CyclicBarrier syncB = new CyclicBarrier(2);
        final CyclicBarrier syncC = new CyclicBarrier(2);
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"foo"));
        this.shell.publish(new ShellProcess(){

            public void execute(ShellProcessContext processContext) {
                try {
                    syncA.await();
                    syncB.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void cancel() {
                try {
                    syncC.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        syncA.await();
        this.term.publish((TermEvent)TermEvent.brk());
        syncC.await();
        this.term.publish((TermEvent)TermEvent.close());
        AsyncProcessorTestCase.assertJoin(this.thread);
        syncB.await();
    }

    public void testBreak() throws Exception {
        final CyclicBarrier syncA = new CyclicBarrier(2);
        final CyclicBarrier syncB = new CyclicBarrier(3);
        this.term.publish((TermEvent)TermEvent.readLine((CharSequence)"foo"));
        this.shell.publish(new ShellProcess(){

            public void execute(ShellProcessContext processContext) {
                try {
                    syncA.await();
                    syncB.await();
                }
                catch (Exception e) {
                    throw AbstractTestCase.failure(e);
                }
            }

            public void cancel() {
                try {
                    syncB.await();
                }
                catch (Exception e) {
                    throw AbstractTestCase.failure(e);
                }
            }
        });
        syncA.await();
        this.term.publish((TermEvent)TermEvent.brk());
        syncB.await();
        this.term.publish((TermEvent)TermEvent.close());
        AsyncProcessorTestCase.assertJoin(this.thread);
    }
}

