/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.matcher.impl.Event;
import org.crsh.cmdline.matcher.impl.Mode;
import org.crsh.cmdline.matcher.impl.Status;
import org.crsh.cmdline.matcher.tokenizer.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parser<T>
implements Iterator<Event> {
    private final Tokenizer tokenizer;
    private final String mainName;
    private final Mode mode;
    private CommandDescriptor<T, ?> command;
    private Status status;
    private final LinkedList<Event> next;

    public Parser(Tokenizer tokenizer, ClassDescriptor<T> command, String mainName, Mode mode) {
        this.tokenizer = tokenizer;
        this.command = command;
        this.mainName = mainName;
        this.status = new Status.ReadingOption();
        this.mode = mode;
        this.next = new LinkedList();
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getIndex() {
        return this.tokenizer.getIndex();
    }

    public Status getStatus() {
        return this.status;
    }

    public Delimiter getDelimiter() {
        return this.tokenizer.getDelimiter();
    }

    @Override
    public boolean hasNext() {
        if (this.next.isEmpty()) {
            this.determine();
        }
        return this.next.size() > 0;
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next.removeFirst();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void determine() {
        while (this.next.isEmpty()) {
            Status.Response nextStatus = this.status.process(new Status.Request(this.mode, this.mainName, this.tokenizer, this.command));
            if (nextStatus.status != null) {
                this.status = nextStatus.status;
            }
            if (nextStatus.events != null) {
                this.next.addAll(nextStatus.events);
            }
            if (nextStatus.command == null) continue;
            this.command = nextStatus.command;
        }
    }
}

