/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.standalone;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.plugin.ServiceLoaderDiscovery;
import org.crsh.util.Utils;
import org.crsh.vfs.FS;
import org.crsh.vfs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap
extends PluginLifeCycle {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<File> bins = Utils.newArrayList();
    private List<File> confs = Utils.newArrayList();
    private List<File> jars = Utils.newArrayList();
    private ClassLoader baseLoader;

    public Bootstrap(ClassLoader baseLoader) throws NullPointerException {
        if (baseLoader == null) {
            throw new NullPointerException("No null base loader accepted");
        }
        this.baseLoader = baseLoader;
    }

    public Bootstrap addConfPath(File file) {
        this.confs.add(file);
        return this;
    }

    public Bootstrap addCmdPath(File file) {
        this.bins.add(file);
        return this;
    }

    public Bootstrap addJarPath(File file) {
        this.jars.add(file);
        return this;
    }

    public void bootstrap() throws Exception {
        URL[] urls = new URL[this.jars.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = this.jars.get(i).toURI().toURL();
        }
        URLClassLoader classLoader = new URLClassLoader(urls, this.baseLoader);
        FS binFS = new FS();
        for (File bin : this.bins) {
            binFS.mount(bin);
        }
        binFS.mount(classLoader, Path.get("/crash/commands/"));
        FS confFS = new FS();
        for (File conf : this.confs) {
            confFS.mount(conf);
        }
        confFS.mount(classLoader, Path.get("/crash/"));
        ServiceLoaderDiscovery discovery = new ServiceLoaderDiscovery(classLoader);
        StringBuilder info = new StringBuilder("Booting crash with classpath=");
        info.append(this.jars).append(" and mounts=[");
        for (int i = 0; i < this.bins.size(); ++i) {
            if (i > 0) {
                info.append(',');
            }
            info.append(this.bins.get(i).getAbsolutePath());
        }
        info.append(']');
        this.log.info(info.toString());
        PluginContext context = new PluginContext(discovery, binFS, confFS, classLoader);
        context.refresh();
        this.start(context);
    }

    public void shutdown() {
        this.stop();
    }
}

