/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.processor;

import java.security.Principal;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.shell.concurrent.AsyncShell;
import org.crsh.shell.impl.CRaSH;
import org.crsh.shell.impl.CRaSHSession;
import org.crsh.term.BaseTerm;
import org.crsh.term.processor.Processor;
import org.crsh.term.spi.TermIO;
import org.crsh.term.spi.TermIOHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorIOHandler
extends CRaSHPlugin<TermIOHandler>
implements TermIOHandler {
    private ExecutorService executor;
    private CRaSH crash;

    @Override
    public TermIOHandler getImplementation() {
        return this;
    }

    @Override
    public void init() {
        this.executor = Executors.newFixedThreadPool(3);
        this.crash = new CRaSH(this.getContext());
    }

    @Override
    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public void handle(TermIO io, Principal user) {
        CRaSHSession shell = this.crash.createSession(user);
        AsyncShell asyncShell = new AsyncShell(this.executor, shell);
        BaseTerm term = new BaseTerm(io);
        Processor processor = new Processor(term, asyncShell);
        processor.addListener(io);
        processor.addListener(asyncShell);
        processor.addListener(shell);
        processor.run();
    }
}

