/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.spi;

import java.util.StringTokenizer;

public abstract class Value {
    private final String string;

    public Value(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("No null string accepted");
        }
        this.string = string;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.string.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass().equals(this.getClass())) {
            Value that = (Value)obj;
            return this.string.equals(that.string);
        }
        return false;
    }

    public final String getString() {
        return this.string;
    }

    public final String toString() {
        return this.string;
    }

    public static class Properties
    extends Value {
        public Properties(String string) throws NullPointerException {
            super(string);
        }

        public java.util.Properties getProperties() {
            java.util.Properties props = new java.util.Properties();
            StringTokenizer tokenizer = new StringTokenizer(this.getString(), ";", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.contains("=")) continue;
                String key = token.substring(0, token.indexOf(61));
                String value = token.substring(token.indexOf(61) + 1, token.length());
                props.put(key, value);
            }
            return props;
        }
    }
}

