/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import org.crsh.command.SyntaxException;
import org.crsh.shell.impl.command.PipeLine;
import org.crsh.shell.impl.command.Token;
import org.crsh.shell.impl.command.Tokenizer;

class Parser {
    private Tokenizer tokenizer;
    private Token token;

    public Parser(CharSequence s) {
        this.tokenizer = new Tokenizer(s);
        this.token = this.tokenizer.nextToken();
    }

    public PipeLine parse() {
        if (this.token == Token.EOF) {
            return null;
        }
        return this.parseExpr();
    }

    private PipeLine parseExpr() {
        if (this.token instanceof Token.Command) {
            PipeLine next;
            Token.Command command = (Token.Command)this.token;
            this.token = this.tokenizer.nextToken();
            if (this.token == Token.EOF) {
                next = null;
            } else if (this.token == Token.PIPE) {
                this.token = this.tokenizer.nextToken();
                next = this.parseExpr();
            } else {
                throw new SyntaxException("Syntax error");
            }
            return new PipeLine(command.line, next);
        }
        throw new SyntaxException("Syntax error");
    }
}

