/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import org.crsh.text.ui.Border;

public abstract class ColumnLayout {
    private static final ColumnLayout RTL = new ColumnLayout(){

        int[] compute(Border border, int viewWidth, int[] colWidths, int[] colMinWidths) {
            int[] ret = (int[])colWidths.clone();
            int total = 0;
            for (int colWidth : colWidths) {
                if (border != null) {
                    ++total;
                }
                total += colWidth;
            }
            if (border != null) {
                ++total;
            }
            for (int index = colMinWidths.length - 1; total > viewWidth && index >= 0; --index) {
                int delta = total - viewWidth;
                int bar = colWidths[index] - colMinWidths[index];
                if (delta <= bar) {
                    int sub = Math.min(bar, delta);
                    total -= sub;
                    int n = index;
                    ret[n] = ret[n] - sub;
                    continue;
                }
                int foo = colWidths[index];
                if (border != null) {
                    ++foo;
                    if (index == 0) {
                        ++foo;
                    }
                }
                total -= foo;
                ret[index] = 0;
            }
            return (int[])(total > 0 ? ret : null);
        }
    };

    public static ColumnLayout rightToLeft() {
        return RTL;
    }

    public static ColumnLayout weighted(int ... weights) throws NullPointerException, IllegalArgumentException {
        return new Weighted(weights);
    }

    abstract int[] compute(Border var1, int var2, int[] var3, int[] var4);

    public static class Weighted
    extends ColumnLayout {
        private final int[] weights;

        private Weighted(int ... weights) throws NullPointerException, IllegalArgumentException {
            if (weights == null) {
                throw new NullPointerException("No null weights accepted");
            }
            for (int weight : weights) {
                if (weight >= 0) continue;
                throw new IllegalArgumentException("No negative weight accepted");
            }
            this.weights = (int[])weights.clone();
        }

        public int[] getWeights() {
            return (int[])this.weights.clone();
        }

        int[] compute(Border border, int width, int[] widths, int[] minWidths) {
            int len;
            for (int i = len = Math.min(widths.length, this.weights.length); i > 0; --i) {
                int totalWeight = 0;
                int width2 = width;
                for (int j = 0; j < i; ++j) {
                    totalWeight += this.weights[j];
                    if (border == null) continue;
                    if (j == 0) {
                        width2 -= 2;
                        continue;
                    }
                    --width2;
                }
                int[] ret = new int[widths.length];
                for (int j = 0; j < i; ++j) {
                    int w = width2 * this.weights[j];
                    if (w < minWidths[j] * totalWeight) {
                        ret = null;
                        break;
                    }
                    ret[j] = w;
                }
                if (ret == null) continue;
                int err = 0;
                for (int j = 0; j < ret.length; ++j) {
                    int value = ret[j] / totalWeight;
                    int lower = value * totalWeight;
                    int errLower = err + ret[j] - lower;
                    int upper = lower + totalWeight;
                    int errUpper = err + ret[j] - upper;
                    if (Math.abs(errLower) < Math.abs(errUpper)) {
                        ret[j] = value;
                        err = errLower;
                        continue;
                    }
                    ret[j] = value + 1;
                    err = errUpper;
                }
                return ret;
            }
            return null;
        }
    }
}

