/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.LabelRenderer;

public class LabelElement
extends Element {
    final String value;
    final int minWidth;
    final int width;

    private static int width(String s, int index) {
        if (index < s.length()) {
            int pos = s.indexOf(10, index + 1);
            if (pos == -1) {
                return s.length() - index;
            }
            return Math.max(pos - index, LabelElement.width(s, pos + 1));
        }
        return 0;
    }

    public LabelElement(String value, int minWidth) {
        if (minWidth < 0) {
            throw new IllegalArgumentException("No negative min size allowed");
        }
        int width = LabelElement.width(value, 0);
        this.value = value;
        this.minWidth = Math.min(width, minWidth);
        this.width = width;
    }

    public LabelElement(String value) {
        this(value, 1);
    }

    public LabelElement(Object value, int minWidth) {
        this(String.valueOf(value), minWidth);
    }

    public LabelElement(Object value) {
        this(String.valueOf(value));
    }

    public String getValue() {
        return this.value;
    }

    public Renderer renderer() {
        return new LabelRenderer(this);
    }

    public String toString() {
        return "Label[" + this.value + "]";
    }

    public LabelElement style(Style.Composite style) {
        return (LabelElement)super.style(style);
    }
}

