/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderer;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.TreeElement;

class TreeRenderer
extends Renderer {
    private final Renderer value;
    private final List<Renderer> children;

    TreeRenderer(TreeElement tree) {
        ArrayList<Renderer> children = new ArrayList<Renderer>(tree.children.size());
        for (Element child : tree.children) {
            children.add(child.renderer());
        }
        this.children = children;
        this.value = tree.value != null ? tree.value.renderer() : null;
    }

    public int getActualWidth() {
        int width = this.value != null ? this.value.getActualWidth() : 0;
        for (Renderer child : this.children) {
            width = Math.max(width, 2 + child.getActualWidth());
        }
        return width;
    }

    public int getMinWidth() {
        int width = this.value != null ? this.value.getMinWidth() : 0;
        for (Renderer child : this.children) {
            width = Math.max(width, 2 + child.getMinWidth());
        }
        return width;
    }

    public LineReader renderer(final int width) {
        final LinkedList<LineReader> renderers = new LinkedList<LineReader>();
        for (Renderer child : this.children) {
            renderers.addLast(child.renderer(width - 2));
        }
        return new LineReader(){
            LineReader value;
            boolean node;
            {
                this.value = TreeRenderer.this.value != null ? TreeRenderer.this.value.renderer(width) : null;
                this.node = true;
            }

            public boolean hasLine() {
                if (this.value != null) {
                    if (this.value.hasLine()) {
                        return true;
                    }
                    this.value = null;
                }
                while (renderers.size() > 0) {
                    if (((LineReader)renderers.peekFirst()).hasLine()) {
                        return true;
                    }
                    renderers.removeFirst();
                    this.node = true;
                }
                return false;
            }

            public void renderLine(RenderAppendable to) {
                if (this.value != null) {
                    if (this.value.hasLine()) {
                        this.value.renderLine(to);
                    } else {
                        this.value = null;
                    }
                }
                if (this.value == null) {
                    while (renderers.size() > 0) {
                        LineReader first = (LineReader)renderers.peekFirst();
                        if (!first.hasLine()) continue;
                        if (this.node) {
                            to.append("+-");
                            this.node = false;
                        } else {
                            Iterator i = renderers.descendingIterator();
                            boolean rest = false;
                            while (i.hasNext()) {
                                LineReader renderer = (LineReader)i.next();
                                if (!i.hasNext() || !renderer.hasLine()) continue;
                                rest = true;
                                break;
                            }
                            if (rest) {
                                to.append("| ");
                            } else {
                                to.append("  ");
                            }
                        }
                        first.renderLine(to);
                        break;
                    }
                }
            }
        };
    }
}

